/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 * Created on 16.12.2005
 * @author Toni Kalajainen
 */
package org.simantics.utils.ui.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.simantics.utils.DataContainer;


/**
 * Tool for making blocking message dialogs queries from non-UI thread
 * 
 * 
 */
public class SafeMessageDialog {

    /** Yes and No buttons */
    public final static String[] YES_NO = new String[] { IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL };

    public static Integer doMessageDialog(final String title, final Image image, final String message, final int type,
            final String buttons[], final int defaultIndex) {
        final DataContainer<Integer> result = new DataContainer<Integer>();
        Runnable r = new Runnable() {
            public void run() {
                Shell shell = Display.getCurrent().getActiveShell();
                MessageDialog dialog = new MessageDialog(shell, title, image, message, type, buttons, defaultIndex);
                dialog.open();
                result.set(dialog.getReturnCode());
            }
        };
        Display display = Display.getCurrent();
        if (display == null)
        	display = Display.getDefault();
        display.syncExec(r);

        if (result.get() == null)
            return null;
        return result.get();
    }

    /**
     * method for asking simple yes/no question in a dialog.
     * 
     * @param title the dialog's title, or <code>null</code> if none
     * @param message the message
     * @return true if user pressed OK
     */
    public static boolean openQuestion(String title, String message) {
        Integer result = doMessageDialog(title, null, message, MessageDialog.QUESTION, YES_NO, 0);
        if (result == null)
            return false;
        return result == 0;
    }

}
