/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.ui.action;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;

/**
 * Extendable implementation of {@link IPriorityAction} based on {@link Action}.
 * PriorityActions are comparable by their priorities.
 * 
 * Note: this class has a natural ordering that is inconsistent with equals.
 * 
 * @author Tuukka Lehtonen
 */
public class PriorityAction extends Action implements IPriorityAction {

    private final int priority;
    
    public PriorityAction() {
        super();
        this.priority = IPriorityAction.NORMAL;
    }

    public PriorityAction(String text, ImageDescriptor image) {
        super(text, image);
        this.priority = IPriorityAction.NORMAL;
    }

    public PriorityAction(String text, int style) {
        super(text, style);
        this.priority = IPriorityAction.NORMAL;
    }

    public PriorityAction(String text) {
        super(text);
        this.priority = IPriorityAction.NORMAL;
    }

    public PriorityAction(int priority) {
        super();
        this.priority = priority;
    }

    public PriorityAction(int priority, String text, ImageDescriptor image) {
        super(text, image);
        this.priority = priority;
    }

    public PriorityAction(int priority, String text, int style) {
        super(text, style);
        this.priority = priority;
    }

    public PriorityAction(int priority, String text) {
        super(text);
        this.priority = priority;
    }
    
    /* (non-Javadoc)
     * @see org.simantics.utils.ui.action.IPriorityAction#getPriority()
     */
    public int getPriority() {
        return priority;
    }

    public int compareTo(IPriorityAction o) {
        int op = o.getPriority();
        // delta < 0 when priority < op
        // delta > 0 when priority > op
        int delta = op - getPriority();
        return delta;
    }
    
}
