/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.ui;

import java.io.File;
import java.net.URL;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

/**
 * Utilities for locating OSGi bundle contents on local media.
 */
public final class PathUtils {
    
    /**
     * Get the absolute path to the specified file in the specified bundle as an
     * IPath. An absolute path is only available for files that are extracted
     * onto any local or network mapped location. Files inside archived bundles
     * aren't considered to have an absolute path since they cannot be executed
     * as such.
     * 
     * @param inBundle
     * @param fullpath
     * @return <code>null</code> if the specified file was not found under the
     *         specified bundle or the bundle is archived.
     */
    public static IPath getAbsolutePath(Bundle inBundle, String fullpath) {
//        System.out.println("getAbsolutePath: " + inBundle + ", " + fullpath);
        IPath path = new Path(fullpath);
        URL u = FileLocator.find(inBundle, path, null);
        if (u != null) {
            try {
                u = FileLocator.resolve(u);
//                System.out.println("  PROTOCOL: " + u.getProtocol());
//                System.out.println("  FILE: " + u.getFile());
                // an absolute path is only available for the file protocol.
                if ("file".equals(u.getProtocol())) {
                    IPath p = new Path(new File(u.getFile()).getAbsolutePath());
                    return p;
                }
            } catch (Exception e) {
            }
        }
        return null;
    }

    /**
     * Get the absolute path to the specified file in the specified bundle as a
     * String.
     * 
     * @param inBundle
     * @param fullpath
     * @return <code>null</code> if the specified file was not found under the
     *         specified bundle
     */
    public static String getAbsolutePathString(Bundle inBundle, String fullpath) {
        IPath p = getAbsolutePath(inBundle, fullpath);
        return (p != null) ? p.toOSString() : null;
    }

    public static IPath getAbsolutePath(String inBundle, String fullpath) {
        Bundle b = Platform.getBundle(inBundle);
        if (b == null)
            return null;
        return getAbsolutePath(b, fullpath);
    }

    public static String getAbsolutePathString(String inBundle, String fullpath) {
        Bundle b = Platform.getBundle(inBundle);
        if (b == null)
            return null;
        return getAbsolutePathString(b, fullpath);
    }
    
}
