/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.threads.ua;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;

public class SerialExecutor
implements Executor {
    final Queue<Runnable> tasks = new ArrayDeque<Runnable>();
    final Executor executor;
    Runnable active;

    public SerialExecutor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public synchronized void execute(final Runnable r) {
        this.tasks.offer(new Runnable(){

            @Override
            public void run() {
                try {
                    r.run();
                }
                finally {
                    SerialExecutor.this.scheduleNext();
                }
            }
        });
        if (this.active == null) {
            this.scheduleNext();
        }
    }

    protected synchronized void scheduleNext() {
        this.active = this.tasks.poll();
        if (this.active != null) {
            this.executor.execute(this.active);
        }
    }
}

