/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.xml;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;


public class Node implements Iterable<Node> {
    public static final short ELEMENT_NODE              = org.w3c.dom.Node.ELEMENT_NODE;
    public static final short ATTRIBUTE_NODE            = org.w3c.dom.Node.ATTRIBUTE_NODE;
    public static final short TEXT_NODE                 = org.w3c.dom.Node.TEXT_NODE;
    public static final short CDATA_SECTION_NODE        = org.w3c.dom.Node.CDATA_SECTION_NODE;
    public static final short ENTITY_REFERENCE_NODE     = org.w3c.dom.Node.ENTITY_REFERENCE_NODE;
    public static final short ENTITY_NODE               = org.w3c.dom.Node.ENTITY_NODE;
    public static final short PROCESSING_INSTRUCTION_NODE = org.w3c.dom.Node.PROCESSING_INSTRUCTION_NODE;
    public static final short COMMENT_NODE              = org.w3c.dom.Node.COMMENT_NODE;
    public static final short DOCUMENT_NODE             = org.w3c.dom.Node.DOCUMENT_NODE;
    public static final short DOCUMENT_TYPE_NODE        = org.w3c.dom.Node.DOCUMENT_TYPE_NODE;
    public static final short DOCUMENT_FRAGMENT_NODE    = org.w3c.dom.Node.DOCUMENT_FRAGMENT_NODE;
    public static final short NOTATION_NODE             = org.w3c.dom.Node.NOTATION_NODE;
	
	private org.w3c.dom.Node node;

	public Node(org.w3c.dom.Node node) {
		this.node = node;
	}
	
	public Node(File file) throws IOException {
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder;
		try {
			builder = factory.newDocumentBuilder();		
			node = builder.parse(file);
		} catch (ParserConfigurationException e) {
			throw new IOException(e);
		} catch (SAXException e) {
			throw new IOException(e);
		}
	}

	static class NodeIterator implements Iterator<Node> {
		NodeList list;		
		int      i;
		int      length;

		public NodeIterator(NodeList list) {
			this.list = list;
			i = 0;
			length = list.getLength();
		}

		@Override
		public boolean hasNext() {
			return i<length;
		}

		@Override
		public Node next() {
			return new Node(list.item(i++));
		}

		@Override
		public void remove() {
			throw new UnsupportedOperationException();
		}		
		
	}
	
	@Override
	public Iterator<Node> iterator() {
		return new NodeIterator(node.getChildNodes());
	}	
	
	public String name() {
		return node.getNodeName();
	}
	
	public String value() {
		return node.getNodeValue().trim();		
	}
	
	public int type() {
		return node.getNodeType();
	}
	
	public Node parent() {
		return new Node(node.getParentNode());
	}
	
	public Node get(String key) {
		return new Node(node.getAttributes().getNamedItem(key));
	}
	
	public String getValue(String key) {
		return node.getAttributes().getNamedItem(key).getNodeValue().trim();		
	}
	
	public int childCount() {
		return node.getChildNodes().getLength();
	}
	
	public String text() {
		return node.getTextContent().trim();
	}
	
	public Node getSingleChild(String type) {
		NodeList nodeList = node.getChildNodes();
		Node child = null;
		for(int i=0;i<nodeList.getLength();++i) {
			org.w3c.dom.Node c = nodeList.item(i);
			if(c.getNodeName().equals(type)) {
				if(child == null)
					child = new Node(c);
				else
					System.out.println("Child of type " + type + " is not unique.");
			}
		}
		return child;
	}
	
	@Override
	public boolean equals(Object obj) {
		return this == obj || (obj instanceof Node && node.equals(((Node)obj).node));
	}
	
}

