/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.format;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Locale;


/**
 * 
 * @author toni.kalajainen
 */
public enum ValueFormat {
	
	Currency ( new DecimalFormat("#,##0.#######;-#,##0.#####", Impl.SYMBOLS) ),
	Scientific( new DecimalFormat("0.###E0", Impl.SYMBOLS) ),
	Engineering( new DecimalFormat("##0.###E0", Impl.SYMBOLS) ),
	Default ( new SwitchFormat(1e-5, 1e5, Scientific.format, Currency.format, Scientific.format) );

	public final NumberFormat format;
	ValueFormat(NumberFormat format) { this.format = format; };
	
	public Format toFormat( int noOfDecimals ) 
	{
		switch ( this ) {
			case Currency: return noOfDecimals>decimalFormats.length||noOfDecimals<0 ? decimalFormats[decimalFormats.length-1] : decimalFormats[Math.min(noOfDecimals, 16)]; 
			case Scientific: return format;
			case Engineering: return format;
			case Default: return noOfDecimals>defaultFormats.length||noOfDecimals<0 ? defaultFormats[defaultFormats.length-1] : defaultFormats[Math.min(noOfDecimals, 16)];
			default: return format;
		}
	}
	
	public static void main(String[] args) {
		double value = 1234567.8901234567890123456;
		for (int i=0; i<10; i++) {
			System.out.println("value="+value+", decimalformat["+i+"]="+decimalFormats[i].format(value));
		}
		value = 567.8901234567890123456;
		for (int i=0; i<10; i++) {
			System.out.println("value="+value+", decimalformat["+i+"]="+decimalFormats[i].format(value));
		}
	}
	
	private static DecimalFormat decimalFormats[] = new DecimalFormat[17];
	private static Format defaultFormats[] = new Format[17];
	
	static {
		String decimals = "";
		for ( int i=0; i<decimalFormats.length; i++ ) {
			decimalFormats[i] = new DecimalFormat("#,###"+decimals+";-#,###"+decimals, Impl.SYMBOLS);
			defaultFormats[i] = new SwitchFormat(1e-5, 1e5, Scientific.format, decimalFormats[i], Scientific.format);
			if ( i==0 ) decimals += ".";
			decimals += "#";
		}
	}

	private static class Impl {
		private static final DecimalFormatSymbols SYMBOLS;
		static {
			SYMBOLS = DecimalFormatSymbols.getInstance(Locale.US);
			SYMBOLS.setGroupingSeparator(' ');
		}
	}

}
