/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils;

import java.util.Collection;

/**
 * GroupRuntimeException is a RuntimeException container for a set of exceptions.
 * 
 * <p>
 * Use {@link #group(Collection)} or {@link #group(Exception[])} to construct
 * it.
 * 
 * @author Toni Kalajainen
 */
public class GroupRuntimeException extends RuntimeException {

    private static final long serialVersionUID = 1L;

    private RuntimeException errors[];
    
    private GroupRuntimeException(RuntimeException[] errors) {
        super(GroupRuntimeException.getAsText(errors));
        this.errors = errors;
    }

    public static RuntimeException group(RuntimeException... errors) {
        if (errors.length == 0)
            throw new IllegalArgumentException("zero exceptions for GroupRuntimeException");
        if (errors.length == 1)
            return errors[0];
        return new GroupRuntimeException(errors);
    }

    public static RuntimeException group(Collection<RuntimeException> collection) {
        if (collection.size() == 0)
            throw new IllegalArgumentException("zero exceptions for GroupRuntimeException");
        if (collection.size() == 1)
            return collection.iterator().next();
        return new GroupRuntimeException(collection.toArray(new RuntimeException[collection.size()]));
    }
    
    private static String getAsText(Throwable errors[]) {
        String result = "";
        for (Throwable error : errors) {
            result += error.getClass().getName()+": "+error.getMessage() + "\n";
        }
        return result;
    }
    
    public RuntimeException[] getErrors() {
        return errors;
    }

}
