/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.datastructures.hints;

import org.simantics.utils.datastructures.hints.IHintContext.Key;

/**
 * @author Tuukka Lehtonen
 */
public class HintTrackerTest extends HintStack {

    public static void main(String[] args) {
        IHintContext ctx1 = new HintContext();
        IHintContext ctx2 = new HintContext();

        Key key1 = new IHintContext.KeyOf(Object.class);
        Key key2 = new IHintContext.KeyOf(Object.class);

        final HintTracker t1 = new HintTracker();
        final HintTracker t2 = new HintTracker();

        t1.addKeyHintListener(key1, new HintListenerAdapter() {
            @Override
            public void hintChanged(IHintObservable sender, Key key, Object oldValue, Object newValue) {
                System.out.println("secondary tracked hint context changed: " + newValue);
                t2.track((IHintContext) newValue);
            }
        });
        t2.addKeyHintListener(key2, new HintListenerAdapter() {
            @Override
            public void hintChanged(IHintObservable sender, Key key, Object oldValue, Object newValue) {
                System.out.println("set view input to: " + newValue);
            }
        });
        t1.track(ctx1);
        
        ctx1.setHint(key1, ctx2);
        ctx2.setHint(key2, new Object());
    }

}