/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.datastructures.cache;

import java.lang.ref.WeakReference;

/**
 * Caches the value provided by provider until the value has been garbage collected.
 * <p>
 * Cached IProvider provides the same instance as long as it is in memory.
 * <p>
 * Cached version is equal to original in hashCode/equals wise.
 * 
 * @author Toni Kalajainen
 */
public class WeakCachedProvider<V> implements IProvider<V> {

    public static final <V> IProvider<V> cache(IProvider<V> provider)
    {
        if (provider instanceof WeakCachedProvider<?>)
            return provider;
        return new WeakCachedProvider<V>(provider);
    }

    IProvider<V> provider;
    WeakReference<V> ref;

    WeakCachedProvider(IProvider<V> orig)
    {
        this.provider = orig;
    }

    @Override
    public synchronized V get() throws ProvisionException {
        if (ref!=null) {
            V x = ref.get();
            if (x==null) ref=null;
            else return x;
        }
        V x = provider.get();
        ref = new WeakReference<V>(x);
        return x;
    }

    @Override
    public int hashCode() {
        return provider.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return provider.equals(obj);
    }

}
