/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench.editor;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.WorkbenchException;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.ui.workbench.ResourceViewPartUtils;
import org.simantics.ui.workbench.action.ResourceEditorAdapterAction;
import org.simantics.ui.workbench.editor.AbstractEditorAdapter;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.action.IPriorityAction;
import org.simantics.utils.ui.action.PriorityActionAdapter;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public abstract class AbstractResourceEditorAdapter
extends AbstractEditorAdapter {
    public AbstractResourceEditorAdapter(String name) {
        super(name, null, 0);
    }

    public AbstractResourceEditorAdapter(String name, ImageDescriptor icon) {
        super(name, icon, 0);
    }

    public AbstractResourceEditorAdapter(String name, ImageDescriptor icon, int priority) {
        super(name, icon, priority);
    }

    protected boolean canHandle(ReadGraph g, Resource input) throws DatabaseException {
        return false;
    }

    protected void openEditor(Resource input) throws Exception {
    }

    @Override
    public boolean canHandle(ReadGraph g, Object input) throws DatabaseException {
        Resource r = ResourceAdaptionUtils.toSingleResource(input);
        if (r == null) {
            return false;
        }
        return this.canHandle(g, r);
    }

    @Override
    public void openEditor(Object input) throws Exception {
        Resource r = ResourceAdaptionUtils.toSingleResource(input);
        if (r != null) {
            this.openEditor(r);
        }
    }

    protected void openViewWithId(String viewId, Resource id, String suffix) throws Exception {
        Session ls = Simantics.getSession();
        ResourceViewPartUtils.activateViewForResource(viewId, ls, id, null);
    }

    protected void openViewWithId(String viewId, Resource id) throws Exception {
        this.openViewWithId(viewId, id, null);
    }

    protected void openViewWithIdInPerspective(String viewId, Resource id, String perspectiveId) throws Exception {
        try {
            WorkbenchUtils.showPerspective((String)perspectiveId);
        }
        catch (WorkbenchException e) {
            ErrorLogger.getDefault().logError("Could not open perspective with ID'" + perspectiveId + "'.", (Throwable)e);
        }
        this.openViewWithId(viewId, id);
    }

    public IAction toAction(Resource r) {
        return new ResourceEditorAdapterAction(this, r);
    }

    public IPriorityAction toPriorityAction(int priority, Resource r) {
        return new PriorityActionAdapter(priority, this.toAction(r));
    }
}

