/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.toolbar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ICommandListener;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.State;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.simantics.db.common.utils.Logger;
import org.simantics.ui.internal.Activator;
import org.simantics.ui.toolbar.CommandStateListener;
import org.simantics.ui.toolbar.CommandStateRegistry;
import org.simantics.ui.toolbar.ToolBarCommandRegistry;
import org.simantics.utils.datastructures.MapList;
import org.simantics.utils.ui.ExceptionUtils;

public class ToolbarContributor
extends EditorActionBarContributor
implements ICommandListener,
IPartListener,
CommandStateListener,
IExecutableExtension {
    private static boolean DEBUG = false;
    private boolean REUSE = true;
    private static final String PLATFORM = "platform:/plugin/";
    private String toolbarId;
    private IEditorPart activePart;
    private Set<IEditorPart> parts = new HashSet<IEditorPart>();
    IToolBarManager mgr;
    ICommandService service;
    IHandlerService handlerService;
    List<IContributionItem> items = new ArrayList<IContributionItem>();
    MapList<String, CommandAction> actions = new MapList();
    CommandStateRegistry stateRegistry;
    IPartListener partListener;
    private Map<String, ComboContribution> menus = new HashMap<String, ComboContribution>();
    private ICoolBarManager coolBarManager;
    private IContributionItem toolBar;
    boolean settingState = false;

    public ToolbarContributor() {
        this.service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        this.handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        this.stateRegistry = CommandStateRegistry.getInstance();
        this.partListener = new IPartListener(){

            public void partOpened(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partActivated(IWorkbenchPart part) {
                if (part instanceof IEditorPart) {
                    ToolbarContributor.this.setContext2((IEditorPart)part);
                }
            }
        };
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().addPartListener(this.partListener);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            String[] parameters;
            String[] stringArray = parameters = ((String)data).split(";");
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                String parameter = stringArray[n2];
                String[] keyValue = parameter.split("=");
                if (keyValue.length <= 2) {
                    String value;
                    String key = keyValue[0];
                    String string = value = keyValue.length > 1 ? keyValue[1] : "";
                    if ("toolbar".equals(key)) {
                        this.toolbarId = value;
                    } else if ("hide".equals(key)) {
                        this.REUSE = !Boolean.parseBoolean(value);
                    }
                }
                ++n2;
            }
        }
    }

    public String getToolbarId() {
        return this.toolbarId;
    }

    public void contributeToCoolBar(ICoolBarManager coolBarManager) {
        this.coolBarManager = coolBarManager;
        this.toolBar = coolBarManager.find(this.getToolbarId());
        if (this.toolBar instanceof ToolBarContributionItem) {
            this.mgr = ((ToolBarContributionItem)this.toolBar).getToolBarManager();
        }
        if (this.mgr == null) {
            return;
        }
        this.createCommands();
        this.mgr.markDirty();
    }

    private void createCommands() {
        for (ToolBarCommandRegistry.ToolbarCommandExtension ext : ToolBarCommandRegistry.getInstance().getExtensions(this.getToolbarId())) {
            this.addCommand(ext);
        }
    }

    private void addCommand(ToolBarCommandRegistry.ToolbarCommandExtension ext) {
        if (DEBUG) {
            System.out.println("Adding command to toolbar " + this.getToolbarId() + " " + ext);
        }
        String commandId = ext.commandId;
        Command command = this.service.getCommand(commandId);
        ICommandWrapper wrapper = new CommandWrapper(command);
        ParameterizedCommand parameterizedCommand = null;
        if (ext.parameters.size() > 0) {
            try {
                Parameterization[] parameterizations = new Parameterization[ext.parameters.size()];
                int i = 0;
                while (i < ext.parameters.size()) {
                    ToolBarCommandRegistry.Parameter param = ext.parameters.get(i);
                    IParameter parameter = command.getParameter(param.name);
                    parameterizations[i] = new Parameterization(parameter, param.value);
                    ++i;
                }
                parameterizedCommand = new ParameterizedCommand(command, parameterizations);
                wrapper = new ParameterizedCommandWrapper(parameterizedCommand);
            }
            catch (NotDefinedException e) {
                e.printStackTrace();
                ExceptionUtils.logError((Throwable)e);
                return;
            }
        }
        String type = ext.type;
        State toggleState = command.getState("org.eclipse.ui.commands.toggleState");
        State radioState = command.getState("org.eclipse.ui.commands.radioState");
        String name = ext.name;
        ImageDescriptor image = this.getImage(ext);
        CommandAction a = null;
        if (type.equals("toggle") && toggleState != null) {
            a = new CommandCheckboxAction(wrapper, name, image);
            this.stateRegistry.storeDefaultState(commandId);
        } else if (radioState != null && ext.value != null) {
            this.stateRegistry.storeDefaultState(commandId);
            if (type.equals("radio")) {
                a = new CommandRadioAction(wrapper, name, ext.value, image);
            } else if (type.equals("combo")) {
                a = new CommandRadioAction(wrapper, name, ext.value, image);
                ComboContribution combo = this.menus.get(commandId);
                if (this.REUSE && combo == null && (combo = (ComboContribution)this.mgr.find(commandId)) != null) {
                    this.menus.put(commandId, combo);
                    this.items.add((IContributionItem)combo);
                    a.getCommand().addCommandListener((ICommandListener)this);
                    CommandStateRegistry.getInstance().addListener(commandId, (CommandStateListener)this);
                }
                if (combo == null) {
                    combo = new ComboContribution();
                    combo.setId(commandId);
                    this.menus.put(commandId, combo);
                    this.items.add((IContributionItem)combo);
                    this.mgr.add((IContributionItem)combo);
                    a.getCommand().addCommandListener((ICommandListener)this);
                    CommandStateRegistry.getInstance().addListener(commandId, (CommandStateListener)this);
                }
                this.actions.add((Object)commandId, (Object)a);
                combo.addAction(a);
                return;
            }
        } else if (type.equals("push")) {
            a = new CommandPushAction(wrapper, name, image);
        } else {
            if (DEBUG) {
                System.out.println(ext + " is not valid.");
            }
            Logger.defaultLogError((String)(ext + " is not valid."));
            return;
        }
        ActionContributionItem item = null;
        if (this.REUSE) {
            String id = commandId;
            if (ext.value != null) {
                id = String.valueOf(id) + "." + ext.value;
            }
            if ((item = this.mgr.find(id)) == null) {
                item = new ActionContributionItem((IAction)a);
                item.setId(id);
            } else {
                if (DEBUG) {
                    System.out.println("Reusing " + ext);
                }
                a = (CommandAction)item.getAction();
            }
        } else {
            item = new ActionContributionItem((IAction)a);
        }
        a.getCommand().addCommandListener((ICommandListener)this);
        this.actions.add((Object)commandId, (Object)a);
        this.items.add((IContributionItem)item);
        this.mgr.add((IContributionItem)item);
        CommandStateRegistry.getInstance().addListener(commandId, (CommandStateListener)this);
    }

    private ImageDescriptor getImage(ToolBarCommandRegistry.ToolbarCommandExtension ext) {
        ImageDescriptor image = null;
        if (ext.image != null) {
            String plugin = null;
            String file = null;
            if (ext.image.startsWith(PLATFORM)) {
                String s = ext.image.substring(PLATFORM.length());
                int i = s.indexOf("/");
                plugin = s.substring(0, i);
                file = s.substring(i + 1);
            } else {
                plugin = ext.contributorId;
                file = ext.image;
            }
            image = Activator.imageDescriptorFromPlugin((String)plugin, (String)file);
        }
        return image;
    }

    public void commandChanged(CommandEvent commandEvent) {
        if (commandEvent.isHandledChanged() || commandEvent.isEnabledChanged()) {
            Command command = commandEvent.getCommand();
            String commandId = command.getId();
            for (CommandAction a : this.actions.getValues((Object)commandId)) {
                a.setEnabled(command.isHandled() && command.isEnabled());
            }
        }
    }

    public void setActiveEditor(IEditorPart targetEditor) {
        if (targetEditor == this.activePart) {
            return;
        }
        this.setContext(targetEditor);
    }

    @Override
    public void stateChanged(IWorkbenchPart part, String commandId, String state) {
        if (this.settingState) {
            return;
        }
        if (part instanceof IEditorPart) {
            this.setContext((IEditorPart)part);
        }
    }

    private void setContext2(IEditorPart part) {
        if (this.REUSE) {
            return;
        }
        if (this.activePart == part) {
            return;
        }
        this.setContext(null);
    }

    private void setContext(IEditorPart part) {
        this.activePart = part;
        if (this.activePart != null && !this.parts.contains(this.activePart)) {
            this.activePart.getSite().getPage().addPartListener((IPartListener)this);
        }
        if (part != null) {
            for (String commandId : this.actions.getKeys()) {
                for (CommandAction a : this.actions.getValues((Object)commandId)) {
                    a.setEnabled(true);
                }
                ComboContribution menu = this.menus.get(commandId);
                if (menu == null) continue;
                menu.setEnabled(true);
            }
            this.updateActionBars(part);
        } else {
            for (String commandId : this.actions.getKeys()) {
                for (CommandAction a : this.actions.getValues((Object)commandId)) {
                    a.setEnabled(false);
                }
                ComboContribution menu = this.menus.get(commandId);
                if (menu == null) continue;
                menu.setEnabled(false);
            }
        }
    }

    private void updateActionBars(IEditorPart part) {
        this.restoreActionStates();
        part.getEditorSite().getActionBars().updateActionBars();
    }

    public void dispose() {
        if (DEBUG) {
            System.out.println("ToolBarContributor.dispose()");
        }
        this.setActiveEditor(null);
        if (this.mgr != null) {
            if (!this.REUSE) {
                for (IContributionItem item : this.items) {
                    this.mgr.remove(item);
                    item.dispose();
                }
            }
            this.items.clear();
            for (String commandId : this.actions.getKeys()) {
                for (CommandAction a : this.actions.getValues((Object)commandId)) {
                    a.getCommand().removeCommandListener((ICommandListener)this);
                }
            }
            this.actions.clear();
            this.coolBarManager.update(true);
            this.mgr.update(true);
        }
        CommandStateRegistry.getInstance().removeListener(this);
        super.dispose();
        this.activePart = null;
        if (this.partListener != null) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().addPartListener(this.partListener);
            this.partListener = null;
        }
    }

    private void storeRadioActionState(CommandRadioAction action, boolean checked) {
        if (this.activePart == null) {
            return;
        }
        this.settingState = true;
        this.stateRegistry.setEditorState((IWorkbenchPart)this.activePart, action.getCommandId(), action.getValue());
        this.settingState = false;
    }

    private void storeToggleActionState(CommandAction action, boolean checked) {
        if (this.activePart == null) {
            return;
        }
        this.settingState = true;
        this.stateRegistry.setEditorState((IWorkbenchPart)this.activePart, action.getCommandId(), checked);
        this.settingState = false;
    }

    private void restoreActionStates() {
        if (this.activePart == null) {
            return;
        }
        if (DEBUG) {
            System.out.println("Restore " + this.activePart);
        }
        Map<String, Boolean> defaultToggleStates = this.stateRegistry.getDefaultToggleStates();
        for (String commandId : defaultToggleStates.keySet()) {
            for (Object a : this.actions.getValues((Object)commandId)) {
                if (DEBUG) {
                    System.out.println(String.valueOf(commandId) + " def " + defaultToggleStates.get(commandId));
                }
                a.setChecked(defaultToggleStates.get(commandId));
            }
        }
        Map<String, Boolean> editorStates = this.stateRegistry.getEditorToggleStates((IWorkbenchPart)this.activePart);
        if (editorStates != null) {
            for (String commandId : editorStates.keySet()) {
                for (Object a : this.actions.getValues((Object)commandId)) {
                    if (DEBUG) {
                        System.out.println(String.valueOf(commandId) + " " + editorStates.get(commandId));
                    }
                    a.setChecked(editorStates.get(commandId));
                }
            }
        }
        Map<String, String> defaultRadioStates = this.stateRegistry.getDefaultRadioStates();
        for (String commandId : defaultRadioStates.keySet()) {
            String defaultValue = defaultRadioStates.get(commandId);
            for (CommandAction a : this.actions.getValues((Object)commandId)) {
                CommandRadioAction r = (CommandRadioAction)a;
                if (DEBUG) {
                    System.out.println(String.valueOf(commandId) + " def " + r.getValue().equals(defaultValue) + " " + r.getValue());
                }
                r.setChecked(r.getValue().equals(defaultValue));
            }
        }
        Map<String, String> editorRadioStates = this.stateRegistry.getEditorRadioStates((IWorkbenchPart)this.activePart);
        if (editorRadioStates != null) {
            for (String commandId : editorRadioStates.keySet()) {
                String defaultValue = editorRadioStates.get(commandId);
                for (CommandAction a : this.actions.getValues((Object)commandId)) {
                    CommandRadioAction r = (CommandRadioAction)a;
                    if (DEBUG) {
                        System.out.println(String.valueOf(commandId) + " " + r.getValue().equals(defaultValue) + " " + r.getValue());
                    }
                    r.setChecked(r.getValue().equals(defaultValue));
                }
            }
        }
        for (ComboContribution c : this.menus.values()) {
            c.updateSelection();
        }
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        this.parts.remove(part);
        this.stateRegistry.clearStates(part);
        part.getSite().getPage().removePartListener((IPartListener)this);
        this.parts.size();
        if (part instanceof IEditorPart) {
            ((IEditorPart)part).getEditorSite().getActionBars().updateActionBars();
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    private boolean getToggleState(Command command) {
        State toggleState = command.getState("org.eclipse.ui.commands.toggleState");
        return (Boolean)toggleState.getValue();
    }

    private class ComboContribution
    extends WorkbenchWindowControlContribution {
        private TableCombo combo;
        private List<Action> actions = new ArrayList<Action>();

        private ComboContribution() {
        }

        protected Control createControl(Composite parent) {
            Composite container = new Composite(parent, 0);
            GridLayout glContainer = new GridLayout(1, false);
            glContainer.marginTop = 0;
            glContainer.marginHeight = 0;
            glContainer.marginWidth = 0;
            container.setLayout((Layout)glContainer);
            GridData glReader = new GridData(4, 4, false, false, 1, 1);
            this.combo = new TableCombo(container, 2056);
            this.combo.setLayoutData((Object)glReader);
            for (Action a : this.actions) {
                TableItem item = new TableItem(this.combo.getTable(), 0);
                item.setText(a.getText());
                if (a.getImageDescriptor() == null) continue;
                item.setImage(a.getImageDescriptor().createImage());
            }
            this.combo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    int index = ComboContribution.this.combo.getSelectionIndex();
                    if (index == -1) {
                        return;
                    }
                    ((Action)ComboContribution.this.actions.get(index)).run();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.updateSelection();
            return container;
        }

        public boolean addAction(Action a) {
            this.actions.remove(a);
            this.actions.add(a);
            return true;
        }

        void updateSelection() {
            if (this.combo == null) {
                return;
            }
            int i = 0;
            while (i < this.actions.size()) {
                if (this.actions.get(i).isChecked()) {
                    this.combo.select(i);
                    return;
                }
                ++i;
            }
        }

        public void setEnabled(boolean enabled) {
            if (this.combo != null) {
                this.combo.setEnabled(enabled);
            }
        }

        public void dispose() {
            this.combo.dispose();
            super.dispose();
        }
    }

    private abstract class CommandAction
    extends Action {
        private ICommandWrapper command;

        public CommandAction(ICommandWrapper command, String name, ImageDescriptor image, int style) {
            super(name, style);
            this.command = command;
            if (image != null) {
                this.setImageDescriptor(image);
            }
        }

        public void run() {
            this.command.run();
        }

        public Command getCommand() {
            return this.command.getCommand();
        }

        public String getCommandId() {
            return this.command.getCommandId();
        }

        public boolean equals(Object obj) {
            if (obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            CommandAction other = (CommandAction)((Object)obj);
            return this.command.equals(other.command);
        }

        public int hashCode() {
            return this.command.getCommandId().hashCode();
        }
    }

    private class CommandCheckboxAction
    extends CommandAction {
        public CommandCheckboxAction(ICommandWrapper command, String name, ImageDescriptor image) {
            super(command, name, image, 2);
        }

        @Override
        public void run() {
            boolean checked = this.isChecked();
            ToolbarContributor.this.storeToggleActionState(this, checked);
            try {
                if (checked == ToolbarContributor.this.getToggleState(this.getCommand())) {
                    HandlerUtil.toggleCommandState((Command)this.getCommand());
                }
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            super.run();
        }
    }

    private class CommandPushAction
    extends CommandAction {
        public CommandPushAction(ICommandWrapper command, String name, ImageDescriptor image) {
            super(command, name, image, 1);
        }
    }

    private class CommandRadioAction
    extends CommandAction {
        private String value;

        public CommandRadioAction(ICommandWrapper command, String name, String value, ImageDescriptor image) {
            super(command, name, image, 8);
            this.value = value;
        }

        @Override
        public void run() {
            boolean checked = this.isChecked();
            ToolbarContributor.this.storeRadioActionState(this, checked);
            try {
                HandlerUtil.updateRadioState((Command)this.getCommand(), (String)this.value);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                return;
            }
            super.run();
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            CommandRadioAction other = (CommandRadioAction)((Object)obj);
            if (!other.getCommandId().equals(this.getCommandId())) {
                return false;
            }
            return other.value.equals(this.value);
        }
    }

    private class CommandWrapper
    implements ICommandWrapper {
        private Command command;

        public CommandWrapper(Command command) {
            this.command = command;
        }

        @Override
        public Command getCommand() {
            return this.command;
        }

        @Override
        public String getCommandId() {
            return this.command.getId();
        }

        @Override
        public void run() {
            try {
                ToolbarContributor.this.handlerService.executeCommand(this.command.getId(), null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public boolean equals(Object obj) {
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            CommandWrapper other = (CommandWrapper)obj;
            return other.getCommandId().equals(this.getCommandId());
        }
    }

    private static interface ICommandWrapper {
        public Command getCommand();

        public String getCommandId();

        public void run();
    }

    private class ParameterizedCommandWrapper
    implements ICommandWrapper {
        private ParameterizedCommand command;

        public ParameterizedCommandWrapper(ParameterizedCommand command) {
            this.command = command;
        }

        @Override
        public Command getCommand() {
            return this.command.getCommand();
        }

        @Override
        public String getCommandId() {
            return this.command.getId();
        }

        @Override
        public void run() {
            try {
                ToolbarContributor.this.handlerService.executeCommand(this.command, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public boolean equals(Object obj) {
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            ParameterizedCommandWrapper other = (ParameterizedCommandWrapper)obj;
            return other.command.equals((Object)this.command);
        }
    }
}

