/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.dnd;

import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.simantics.db.Session;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.exception.DatabaseException;
import org.simantics.ui.dnd.LocalObjectTransfer;
import org.simantics.ui.dnd.NoImageDragSourceEffect;
import org.simantics.ui.dnd.ResourceReferenceTransfer;
import org.simantics.ui.dnd.ResourceTransferUtils;
import org.simantics.ui.dnd.SessionContainer;
import org.simantics.ui.utils.ResourceAdaptionUtils;

public class BasicDragSource
implements DragSourceListener,
SessionContainer {
    private Transfer[] transferAgents;
    private ISelectionProvider selectionProvider;
    private IStructuredSelection sel;
    private ResourceArray[] resources;
    private Session session;
    private String purpose;

    public BasicDragSource(ISelectionProvider selectionProvider, Control sourceControl, Session session) {
        this(selectionProvider, sourceControl, session, null);
    }

    public BasicDragSource(ISelectionProvider selectionProvider, Control sourceControl, Session session, String purpose) {
        this.selectionProvider = selectionProvider;
        this.transferAgents = new Transfer[]{TextTransfer.getInstance(), ResourceReferenceTransfer.createInstance(purpose), LocalObjectTransfer.getTransfer()};
        this.session = session;
        this.purpose = purpose;
        DragSource source = new DragSource(sourceControl, 23);
        source.setTransfer(this.transferAgents);
        source.addDragListener((DragSourceListener)this);
        source.setDragSourceEffect((DragSourceEffect)new NoImageDragSourceEffect(sourceControl));
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public void setSession(Session session) {
        this.session = session;
    }

    public void dragStart(DragSourceEvent event) {
        event.doit = false;
        if (this.session == null) {
            return;
        }
        this.sel = (IStructuredSelection)this.selectionProvider.getSelection();
        if (this.sel == null || this.sel.isEmpty()) {
            return;
        }
        this.resources = ResourceAdaptionUtils.toResourceArrays((Object)this.sel);
        event.doit = this.resources.length > 0;
    }

    public void dragSetData(DragSourceEvent event) {
        if (ResourceReferenceTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = this.resources;
        } else if (LocalObjectTransfer.getTransfer().isSupportedType(event.dataType)) {
            event.data = this.sel;
        } else if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
            try {
                event.data = ResourceTransferUtils.createStringTransferable(this.session, this.resources, this.purpose);
            }
            catch (DatabaseException e) {
                event.doit = false;
                e.printStackTrace();
            }
        }
    }

    public void dragFinished(DragSourceEvent event) {
        this.sel = null;
        this.resources = null;
    }
}

