/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.auth;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.simantics.ui.auth.model.LoginModel;

/**
 * @author Tuukka Lehtonen
 */
public class LoginDialog extends TrayDialog {

    private static final String LOGIN_DIALOG = "LoginDialog"; //$NON-NLS-1$

    private IDialogSettings     dialogBoundsSettings;

    private LoginComposite      c;

    private final LoginModel          model;

    protected LoginDialog(Shell parentShell, IDialogSettings settings, LoginModel model) {
        super(parentShell);
        this.model = model;

        dialogBoundsSettings = settings.getSection(LOGIN_DIALOG);
        if (dialogBoundsSettings == null)
            dialogBoundsSettings = settings.addNewSection(LOGIN_DIALOG);
    }

    @Override
    protected int getShellStyle() {
        return super.getShellStyle() /*| SWT.RESIZE */;
    }

    @Override
    protected void configureShell(Shell newShell) {
        newShell.setText("Login - " + model.getServer().getName());
        super.configureShell(newShell);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite) super.createDialogArea(parent);

        c = new LoginComposite(composite, SWT.NONE, model);

        GridDataFactory.fillDefaults().grab(true, false).applyTo(c);

        applyDialogFont(composite);

        return composite;
    }

    @Override
    protected IDialogSettings getDialogBoundsSettings() {
        return dialogBoundsSettings;
    }

    @Override
    protected Point getInitialSize() {
        Point defaultSize = getShell().computeSize(SWT.DEFAULT, SWT.DEFAULT, true);
        Point result = super.getInitialSize();
        if (defaultSize.equals(result))
            return new Point(400, 220);
        return result;
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
    }

}
