/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;

import org.eclipse.jface.action.IAction;
import org.simantics.db.ReadGraph;
import org.simantics.utils.datastructures.hints.HintContext;
import org.simantics.utils.ui.action.IPriorityAction;
import org.simantics.utils.ui.action.PriorityActionAdapter;

/**
 * TODO: multiple selection support
 * 
 * @author Tuukka Lehtonen
 */
public class DoubleClickEvent extends EventObject {

    private static final long     serialVersionUID = 1730213767249571862L;

    private boolean               consumed         = false;

    private final ReadGraph       graph;

    private final Object          resource;

    private List<IPriorityAction> actions          = new ArrayList<IPriorityAction>();

    private HintContext           hintContext      = new HintContext();

    public DoubleClickEvent(Object source, ReadGraph g, Object resource) {
        super(source);
        this.graph = g;
        this.resource = resource;
    }

    public ReadGraph getGraph() {
        return graph;
    }

    public Object getResource() {
        return resource;
    }

    /**
     * Mark the event as accepted which suppresses further double click handler
     * calls.
     */
    public void consume() {
        consumed = true;
    }

    public boolean isConsumed() {
        return consumed;
    }

    /**
     * Add a possible action with normal priority.
     * 
     * @param action
     */
    public void add(IAction action) {
        actions.add(new PriorityActionAdapter(IPriorityAction.NORMAL, action));
    }

    /**
     * Add a possible prioritized action.
     * 
     * @param action
     */
    public void add(IPriorityAction action) {
        actions.add(action);
    }

    /**
     * Only used internally by the doubleclick extension point.
     * 
     * @return
     */
    public IPriorityAction[] getOrderedActions() {
        List<IPriorityAction> copy = new ArrayList<IPriorityAction>(actions);
        Collections.sort(copy);
        return copy.toArray(new IPriorityAction[copy.size()]);
    }

    public HintContext getHintContext() {
        return hintContext;
    }

}
