/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.tests.modelled.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.module.coverage.CombinedCoverage;
import org.simantics.scl.compiler.module.coverage.CoverageBuilder;
import org.simantics.tests.modelled.utils.ModelledSTSTest;
import org.simantics.utils.strings.AlphanumComparator;

public class ModelledSTSSuite {
    private String name;
    private List<ModelledSTSTest> children;
    private int priority;
    private String moduleNameFilter;
    private List<Pattern> moduleNameFilterPatterns = new ArrayList<Pattern>();
    private CoverageBuilder coverageBuilder;
    private Map<String, String> variables;
    static Comparator<ModelledSTSTest> comparator = (test1, test2) -> ModelledSTSSuite.compareTests(test1, test2);

    ModelledSTSSuite(String name, List<ModelledSTSTest> children, String moduleNameFilter, int priority, Map<String, String> variables) {
        this.name = name;
        this.priority = priority;
        this.children = children;
        this.variables = variables;
        this.moduleNameFilter = moduleNameFilter;
        String[] stringArray = moduleNameFilter.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            try {
                s = s.trim().replaceAll("\\*", "\\\\w*").toLowerCase();
                this.getModuleNameFilterPatterns().add(Pattern.compile(s));
            }
            catch (PatternSyntaxException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public String getName() {
        return this.name;
    }

    public List<ModelledSTSTest> getChildren() {
        return this.children;
    }

    public List<ModelledSTSTest> getSortedChildren() {
        HashSet<ModelledSTSTest> testsWithDeps = new HashSet<ModelledSTSTest>();
        TreeMap<ModelledSTSTest, String> sortedTests = new TreeMap<ModelledSTSTest, String>(comparator);
        for (ModelledSTSTest test : this.getChildren()) {
            Set<String> testDependencies = test.getDependencies();
            if (testDependencies.isEmpty()) {
                sortedTests.put(test, test.getName());
                continue;
            }
            testsWithDeps.add(test);
        }
        LinkedList<ModelledSTSTest> results = new LinkedList<ModelledSTSTest>(sortedTests.keySet());
        for (ModelledSTSTest testWithDep : testsWithDeps) {
            boolean satisfied = true;
            for (String dep : testWithDep.getDependencies()) {
                if (!sortedTests.containsValue(dep)) {
                    satisfied = false;
                    continue;
                }
                testWithDep.resolveDependency(dep);
            }
            if (satisfied) {
                results.addLast(testWithDep);
                sortedTests.put(testWithDep, testWithDep.getName());
                continue;
            }
            System.out.println(String.valueOf(testWithDep.getName()) + " not satisfied");
        }
        return results;
    }

    private static int compareTests(ModelledSTSTest test1, ModelledSTSTest test2) {
        if (test1.getPriority() < test2.getPriority()) {
            return -1;
        }
        if (test1.getPriority() > test2.getPriority()) {
            return 1;
        }
        return AlphanumComparator.COMPARATOR.compare((Object)test1.getName(), (Object)test2.getName());
    }

    public String getModuleNameFilter() {
        return this.moduleNameFilter;
    }

    public void addCoverage(List<Module> modules) {
        if (this.coverageBuilder == null) {
            this.coverageBuilder = new CoverageBuilder();
        }
        for (Module module : modules) {
            this.coverageBuilder.addCoverage(module, true);
        }
    }

    public CombinedCoverage getCoverage() {
        if (this.coverageBuilder == null) {
            return null;
        }
        return this.coverageBuilder.getCoverage();
    }

    public List<Pattern> getModuleNameFilterPatterns() {
        return this.moduleNameFilterPatterns;
    }

    public int getPriority() {
        return this.priority;
    }
}

