/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.team.ui;

import java.io.File;
import java.io.IOException;
import java.util.Deque;
import java.util.LinkedList;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.team.Utils;
import org.simantics.team.ui.Preferences;
import org.simantics.team.ui.StageInitPage;
import org.simantics.utils.ui.ErrorLogger;

public class StageInitWizard
extends Wizard
implements IImportWizard {
    private final Data data;
    private static final int MAX_RECENT_IMPORT_PATHS = 10;

    public static boolean openInitWizard(final Data data) throws DatabaseException {
        final Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                StageInitWizard stageInitWizard = new StageInitWizard(data);
                WizardDialog dialog = new WizardDialog(display.getActiveShell(), (IWizard)stageInitWizard);
                data.ok = dialog.open() != 0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
            }
        });
        return data.ok;
    }

    private boolean readPreferences(IStructuredSelection selection) {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.team.ui");
        try {
            this.data.teamFolder = Utils.getTeamFolder();
            if (this.data.teamFolder == null) {
                this.data.teamFolder = new File("Default Team Folder");
            }
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((String)"Failed to get team folder.", (Throwable)e);
            this.data.teamFolder = new File("Default Team Folder");
        }
        String recentPathsPref = store.getString("RECENT_TEAM_FOLDERS");
        this.data.recentLocations = Preferences.decodePaths(recentPathsPref);
        return true;
    }

    private void writePreferences() throws IOException {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.team.ui");
        store.putValue("CURRENT_TEAM_FOLDER", this.data.teamFolder.getAbsolutePath());
        store.putValue("RECENT_TEAM_FOLDERS", Preferences.encodePaths(this.data.recentLocations));
        if (store.needsSaving()) {
            store.save();
        }
    }

    public StageInitWizard(Data data) {
        this.data = data;
        this.setWindowTitle("Staging Init");
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.readPreferences(selection);
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)new StageInitPage(this.data));
    }

    public boolean performFinish() {
        try {
            this.data.recentLocations.addFirst(this.data.teamFolder.getAbsolutePath());
            Preferences.removeDuplicates(this.data.recentLocations);
            if (this.data.recentLocations.size() > 10) {
                this.data.recentLocations.pollLast();
            }
            this.writePreferences();
        }
        catch (IOException e) {
            ErrorLogger.defaultLogError((String)"Failed to write preferences", (Throwable)e);
        }
        return true;
    }

    public static class Data {
        public Boolean ok = false;
        public Boolean requireExisting = false;
        public String comment;
        Deque<String> recentLocations = new LinkedList<String>();
        final File stagingFolder;
        public File teamFolder;

        public Data(File stagingFolder, File teamFolder) {
            this.stagingFolder = stagingFolder;
            this.teamFolder = teamFolder;
        }
    }
}

