/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.team.ui;

import java.util.Collection;
import java.util.Iterator;
import org.simantics.db.Operation;
import org.simantics.db.Session;
import org.simantics.db.UndoContext;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.team.ui.UndoCombinedElement;
import org.simantics.team.ui.UndoContextElement;

class RedoContextElement
extends UndoContextElement {
    RedoContextElement(Session session, UndoContext context) {
        super(session, context);
        this.name = "Redo";
    }

    @Override
    boolean hasChildren() {
        UndoContext c = (UndoContext)this.contextRef.get();
        if (c == null) {
            return false;
        }
        try {
            return c.getRedoList().size() > 0;
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
            return false;
        }
    }

    @Override
    Object[] getChildren() {
        Collection operations;
        UndoContext c = (UndoContext)this.contextRef.get();
        if (c == null) {
            return new Object[0];
        }
        try {
            operations = c.getRedoList();
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
            operations = null;
        }
        if (operations.size() < 1) {
            return new Object[0];
        }
        Object[] objects = new Object[operations.size()];
        Iterator it = operations.iterator();
        int i = operations.size();
        while (it.hasNext()) {
            Operation op = (Operation)it.next();
            objects[--i] = new UndoCombinedElement(this.session, op);
        }
        assert (i == 0);
        return objects;
    }
}

