/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.team.ui;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;
import org.simantics.Simantics;
import org.simantics.db.ChangeSetIdentifier;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.XSupport;
import org.simantics.layer0.Layer0;
import org.simantics.team.Activator;
import org.simantics.team.internal.Images;
import org.simantics.team.ui.ChangeSetElement;
import org.simantics.team.ui.ChangeSetProvider;
import org.simantics.team.ui.CommentColumnLabelProvider;
import org.simantics.team.ui.DateColumnLabelProvider;
import org.simantics.team.ui.IdColumnLabelProvider;
import org.simantics.team.ui.TreeView;
import org.simantics.utils.ui.ExceptionUtils;

public class HistoryView
extends TreeView {
    private void createPopupMenu() {
        MenuManager mm = new MenuManager("Graph History Popup", "#GraphHistoryPopup");
        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new GroupMarker("additions"));
            }
        });
        Menu menu = mm.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
        IWorkbenchPartSite site = this.getSite();
        if (site != null) {
            site.registerContextMenu(mm.getId(), mm, (ISelectionProvider)this.treeViewer);
        }
        this.treeViewer.getControl().addMouseListener((MouseListener)new GraphHistoryMouseAdapter());
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.treeViewer = new TreeViewer(parent, 65540);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources((Display)parent.getDisplay()), (Control)this.treeViewer.getTree());
        Images.getInstance(JFaceResources.getResources());
        TreeColumnLayout ad = new TreeColumnLayout();
        parent.setLayout((Layout)ad);
        this.treeViewer.getTree().setHeaderVisible(true);
        TreeViewerColumn idColumn = new TreeViewerColumn(this.treeViewer, 16384);
        TreeViewerColumn dateColumn = new TreeViewerColumn(this.treeViewer, 16384);
        TreeViewerColumn commentColumn = new TreeViewerColumn(this.treeViewer, 16384);
        idColumn.setLabelProvider((CellLabelProvider)new IdColumnLabelProvider());
        dateColumn.setLabelProvider((CellLabelProvider)new DateColumnLabelProvider());
        commentColumn.setLabelProvider((CellLabelProvider)new CommentColumnLabelProvider());
        idColumn.getColumn().setText("Id");
        idColumn.getColumn().setWidth(20);
        ad.setColumnData((Widget)idColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(50, 20));
        dateColumn.getColumn().setText("Date");
        dateColumn.getColumn().setWidth(20);
        ad.setColumnData((Widget)dateColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(50, 40));
        commentColumn.getColumn().setText("Comment");
        commentColumn.getColumn().setWidth(20);
        ad.setColumnData((Widget)commentColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(50, 50));
        final HistoryContentProvider contentProvider = new HistoryContentProvider(Simantics.getSession());
        this.treeViewer.setContentProvider((IContentProvider)contentProvider);
        this.treeViewer.setInput((Object)this);
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)new Action("Previous", Activator.PREVIOUS_ICON){

            public void run() {
                contentProvider.previous();
            }
        });
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)new Action("Next", Activator.NEXT_ICON){

            public void run() {
                contentProvider.next();
            }
        });
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)new Action("Get Graph History", Activator.REFRESH_ICON){

            public void run() {
                contentProvider.refresh();
            }
        });
        new TreeView.ItemDetailToolTip(this.treeViewer, this.treeViewer.getTree(), null);
        this.createPopupMenu();
    }

    private static void corruptClusterAction(WriteGraph graph) throws DatabaseException {
        XSupport xs = (XSupport)graph.getService(XSupport.class);
        Resource r = graph.newResource();
        String msg = "Corrupt cluster r=" + r;
        System.out.println(msg);
        CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
        cm.add(msg);
        xs.corruptCluster(r);
        Resource rr = graph.newResource();
        msg = "Corrupt cluster rr=" + rr;
        System.out.println(msg);
        cm.add(msg);
        xs.corruptCluster(rr);
        graph.addMetadata((Metadata)cm);
    }

    private static void debugCommitAction(WriteGraph graph) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
        graph.addMetadata((Metadata)cm.add("Debug commit."));
        Resource root = graph.newResource();
        graph.claim(root, l0.InstanceOf, l0.Entity);
        graph.claimLiteral(root, l0.HasName, (Object)"Debug Resource Root");
        Resource project = graph.getResource("http://Projects/Development%20Project");
        graph.claim(root, l0.PartOf, project);
        int count = 1;
        int i = 0;
        while (i < 0x100000) {
            Resource r = graph.newResource();
            graph.claim(r, l0.InstanceOf, l0.Entity);
            graph.claimLiteral(r, l0.HasName, (Object)("Debug Resource " + i));
            if (count % 1000 == 0) {
                root = r;
            } else {
                graph.claim(r, l0.PartOf, l0.ConsistsOf, root);
            }
            ++i;
            ++count;
        }
    }

    static class GraphHistoryMouseAdapter
    extends MouseAdapter {
        final boolean DEBUG = false;

        protected ISelection getClickedContext(MouseEvent e) {
            Point point;
            Tree tree = (Tree)e.getSource();
            TreeItem item = tree.getItem(point = new Point(e.x, e.y));
            if (item == null) {
                return null;
            }
            tree.select(item);
            Object data = item.getData();
            return null;
        }

        public void mouseUp(MouseEvent e) {
            ISelection context = this.getClickedContext(e);
            if (context == null) {
                return;
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
            ISelection context = this.getClickedContext(e);
            if (context == null) {
                return;
            }
        }
    }

    static class HistoryContentProvider
    extends ChangeSetProvider {
        private long topChangeSet = 0L;
        private final int CS_LIMIT = 100;
        private HistoryElement[] changeSetIds;

        HistoryContentProvider(Session session) {
            super(session);
        }

        @Override
        public void refresh() {
            this.topChangeSet = 0L;
            super.refresh();
        }

        @Override
        public Object[] getElements(Object inputElement) {
            try {
                if (0L != this.topChangeSet) {
                    return this.changeSetIds;
                }
                this.changeSetIds = this.getElements(this.managementSupport.getHeadRevisionId());
            }
            catch (DatabaseException e) {
                ExceptionUtils.logAndShowError((Throwable)e);
                this.changeSetIds = new HistoryElement[0];
            }
            return this.changeSetIds;
        }

        private HistoryElement[] getElements(long head) {
            try {
                if (head < 1L) {
                    return new HistoryElement[0];
                }
                long min = Math.max(1L, head - 100L);
                Collection cids = this.managementSupport.getChangeSetIdentifiers(min, head);
                if (cids == null) {
                    this.changeSetIds = new HistoryElement[0];
                } else {
                    this.changeSetIds = new HistoryElement[cids.size()];
                    Iterator it = cids.iterator();
                    int i = cids.size();
                    while (it.hasNext()) {
                        this.changeSetIds[--i] = new HistoryElement(this.session, (ChangeSetIdentifier)it.next());
                    }
                    assert (i == 0);
                }
            }
            catch (DatabaseException e) {
                ExceptionUtils.logAndShowError((Throwable)e);
                this.changeSetIds = new HistoryElement[0];
            }
            return this.changeSetIds;
        }

        void next() {
            if (0L != this.topChangeSet) {
                long head = 0L;
                try {
                    head = this.managementSupport.getHeadRevisionId();
                }
                catch (DatabaseException e) {
                    Logger.defaultLogError((Throwable)e);
                }
                this.topChangeSet = this.topChangeSet + 100L > head ? 0L : (this.topChangeSet += 100L);
                this.changeSetIds = this.getElements(this.topChangeSet);
            }
            super.refresh();
        }

        void previous() {
            long head = 0L;
            try {
                head = this.managementSupport.getHeadRevisionId();
                if (0L == this.topChangeSet) {
                    this.topChangeSet = head;
                }
                if (this.topChangeSet > 101L) {
                    this.topChangeSet -= 100L;
                }
                this.changeSetIds = this.getElements(this.topChangeSet);
            }
            catch (DatabaseException e) {
                Logger.defaultLogError((Throwable)e);
            }
            super.refresh();
        }

        class HistoryElement
        extends ChangeSetElement {
            HistoryElement(Session session, ChangeSetIdentifier cs) {
                super(session, cs);
            }
        }
    }
}

