package org.simantics.structural2.scl;

import java.util.List;

import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.datastructures.Pair;

/**
 * Represents a Component that is not a Composite.
 * 
 * @author Hannu Niemistö
 */
public abstract class StructuralComponent<Connection> extends StructuralConfiguration<Connection> {
    public abstract Resource      getType(ReadGraph g) throws DatabaseException;
    //public abstract Set<Resource> getAttributes(ReadGraph g) throws DatabaseException;
    //public abstract Variant       getValue(ReadGraph g, Resource attribute) throws DatabaseException;
    public abstract Object        getValue(ReadGraph g, Resource attribute, Binding binding) throws DatabaseException, AdaptException;
    public abstract boolean       isParametrized(ReadGraph g) throws DatabaseException;
    public abstract Connection    getConnection(ReadGraph g, Resource connectionPoint) throws DatabaseException;
    public abstract List<Pair<Resource,Connection>> getConnections(ReadGraph g, Resource connectionPoint) throws DatabaseException;
}
