/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.structural2.modelingRules;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.utils.StructuralUtils;

public abstract class AbstractModelingRules implements IModelingRules {
	@Override
	public boolean canPopulate(ReadGraph g, Resource componentType)
		throws DatabaseException {
		return true;
	}
	
	@Override
	public void setConnectionType(WriteGraph g, Resource connection,
			Resource connectionType) throws DatabaseException {
		StructuralResource2 sr = StructuralResource2.getInstance(g);
		for(Resource c : StructuralUtils.getRelatedConnections(g, connection)) {
			g.deny(c, sr.HasConnectionType);
			g.claim(c, sr.HasConnectionType, null, connectionType);
		}
	}
	
	@Override
	public Resource getConnectionType(ReadGraph g, Resource connection) throws DatabaseException {
		StructuralResource2 sr = StructuralResource2.getInstance(g);
		return g.getPossibleObject(connection, sr.HasConnectionType);
	}
}
