/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural.synchronization.protocol;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.simantics.databoard.binding.mutable.Variant;

public class SerializedVariable {
    private Map<String, SerializedVariable> children;
    private Map<String, SerializedVariable> properties;
    public final Variant value;
    public final String name;

    public SerializedVariable(String name, Variant value) {
        this.name = name;
        this.value = value;
    }

    public <T> T getPossiblePropertyValue(String name) {
        if (this.properties == null) {
            return null;
        }
        SerializedVariable p = this.properties.get(name);
        if (p == null) {
            return null;
        }
        return (T)p.value.getValue();
    }

    public <T> T getPropertyValue(String name) {
        if (this.properties == null) {
            throw new AssertionError((Object)("Property '" + name + "' does not exist."));
        }
        SerializedVariable p = this.properties.get(name);
        if (p == null) {
            throw new AssertionError((Object)("Property '" + name + "' does not exist."));
        }
        return (T)p.value.getValue();
    }

    public Collection<SerializedVariable> getProperties() {
        if (this.properties == null) {
            return Collections.emptyList();
        }
        return this.properties.values();
    }

    public static String print(SerializedVariable var, int indent) {
        int i;
        StringBuilder b = new StringBuilder();
        b.append(String.valueOf(var.name) + " " + var.value.getValue());
        if (var.children != null) {
            for (Map.Entry<String, SerializedVariable> child : var.children.entrySet()) {
                b.append("\n");
                i = 0;
                while (i < indent) {
                    b.append(" ");
                    ++i;
                }
                b.append("/" + SerializedVariable.print(child.getValue(), indent + 2));
            }
        }
        if (var.properties != null) {
            for (Map.Entry<String, SerializedVariable> property : var.properties.entrySet()) {
                b.append("\n");
                i = 0;
                while (i < indent) {
                    b.append(" ");
                    ++i;
                }
                b.append("#" + SerializedVariable.print(property.getValue(), indent + 2));
            }
        }
        return b.toString();
    }

    public void addProperty(String name, SerializedVariable property) {
        if (this.properties == null) {
            this.properties = new HashMap<String, SerializedVariable>();
        }
        this.properties.put(name, property);
    }
}

