package org.simantics.structural.synchronization.client;

import java.util.concurrent.ConcurrentMap;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulation.experiment.IExperiment;

public class ContinuousSynchronizationJob extends DatabaseJob {
	
	public static final String FAMILY = "ContinuousSynchronizationJob";

	final private ConcurrentMap<IExperiment, Job> currentSyncJobs;
	
    IExperiment                         experiment;

    public ContinuousSynchronizationJob(IExperiment experiment, ConcurrentMap<IExperiment, Job> currentSyncJobs) {
        super("Synchronization");
        this.experiment = experiment;
        this.currentSyncJobs = currentSyncJobs;
        setPriority(SHORT);
        setSystem(false);
    }
    
    @Override
    public boolean belongsTo(Object family) {
    	if (FAMILY == family) return true;
    	return super.belongsTo(family);
    }

    @Override
    public boolean shouldRun() {
        return currentSyncJobs.remove(experiment, this);
    }

    @Override
    protected IStatus run(IProgressMonitor monitor) {
        try {
            //System.out.println("SYNC #" + (++syncCounter));
            monitor.beginTask("", IProgressMonitor.UNKNOWN);
            if (experiment.getState() != ExperimentState.DISPOSED)
                experiment.refresh(Simantics.getSession());
            return Status.OK_STATUS;
        } catch (Throwable t) {
            return new Status(IStatus.ERROR, "org.simantics.structural.synchronization.client", "Failed to refresh experiment "
                    + experiment + " with ID " + experiment.getIdentifier(), t);
        } finally {
            monitor.done();
        }
    }

}