/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.spreadsheet.ui;

import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.simantics.g2d.chassis.SWTChassis;
import org.simantics.spreadsheet.Adaptable;
import org.simantics.spreadsheet.ClientModel;
import org.simantics.utils.ui.jface.ActiveSelectionProvider;

public class Spreadsheet extends Composite {

	public static boolean DEBUG = false;

	final private SpreadsheetModel sm;

	public SpreadsheetModel getModel() {
		return sm;
	}

	public Spreadsheet(Composite parent, int style, Adaptable serverInterface, ActiveSelectionProvider selectionProvider) {

		super(parent, style);

		sm = new SpreadsheetModel(serverInterface, selectionProvider);

		addDisposeListener(new DisposeListener() {
			@Override
			public void widgetDisposed(DisposeEvent e) {
			}
		});

	}

	public ClientModel getClientModel() {

		return sm.getClientModel();

	}

	public ClientModel getClientInterface() {

		return sm.getClientInterface();

	}

	public void defaultInitializeUI() {

		try {
			// Set System L&F
			UIManager.setLookAndFeel(
					UIManager.getSystemLookAndFeelClassName());
		}
		catch (UnsupportedLookAndFeelException e) {
			// handle exception
		}
		catch (ClassNotFoundException e) {
			// handle exception
		}
		catch (InstantiationException e) {
			// handle exception
		}
		catch (IllegalAccessException e) {
			// handle exception
		}

		setLayout(new FillLayout(SWT.NONE));

		createTable(this);

		// Makes sure that the UI is up-to-date now that
		// ClientTableModel is in play.
		sm.getClientInterface().flush();

	}

	public JTable createTable(Composite parent) {

		SWTChassis c = new SWTChassis(parent, 0){

			@Override
			protected JComponent createSwingComponent() {
				return sm.createComponent(null);
			}
		};
		c.syncPopulate();

		return null;

	}

}
