package org.simantics.spreadsheet.graph.function;

import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.ResourceRead2;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.RuntimeEnvironmentRequest;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.layer0.Layer0;
import org.simantics.scl.compiler.runtime.RuntimeEnvironment;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.structural2.scl.CompileStructuralValueRequest;
import org.simantics.structural2.scl.ComponentTypeProperty;
import org.simantics.structural2.scl.ReadComponentTypeInterfaceRequest;

public class CompileSCLValueRequest extends CompileStructuralValueRequest {

    public CompileSCLValueRequest(ReadGraph graph, Variable context)
            throws DatabaseException {
        super(graph, context);
    }

    public static Object compileAndEvaluate(ReadGraph graph, Variable context) throws DatabaseException {
        SCLContext sclContext = SCLContext.getCurrent();
        Object oldGraph = sclContext.get("graph");
        try {
            Function1<Object,Object> exp = graph.syncRequest(new CompileSCLValueRequest(graph, context),
                    TransientCacheListener.instance());
            sclContext.put("graph", graph);
            return exp.apply(context);
        } catch (DatabaseException e) {
            throw (DatabaseException)e;
        } catch (Throwable t) {
            throw new DatabaseException(t);
        } finally {
            sclContext.put("graph", oldGraph);
        }
    }
    
    @Override
    protected CompilationContext getCompilationContext(ReadGraph graph) throws DatabaseException {
    	Resource indexRoot = graph.syncRequest(new IndexRoot(literal));
        return graph.syncRequest(new ResourceRead2<CompilationContext>(component, indexRoot) {
            @Override
            public CompilationContext perform(ReadGraph graph) throws DatabaseException {
            	Layer0 L0 = Layer0.getInstance(graph);
                Resource parent = graph.getPossibleObject(resource, L0.PartOf);
                Resource type = graph.getPossibleType(parent, L0.Entity);
                RuntimeEnvironment runtimeEnvironment = graph.syncRequest(new RuntimeEnvironmentRequest(resource2));
                Map<String, ComponentTypeProperty> propertyMap =
                        graph.syncRequest(new ReadComponentTypeInterfaceRequest(type, runtimeEnvironment.getEnvironment()),
                                TransientCacheListener.<Map<String, ComponentTypeProperty>>instance());
                return new CompilationContext(runtimeEnvironment, propertyMap);
            }
        });
    }
	
}
