package org.simantics.spreadsheet.graph;

import java.util.ArrayList;
import java.util.List;

import org.simantics.Simantics;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.ProjectModels;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;

public class SCL {

	public static Variant toVariant(Object o) {
		return Variant.ofInstance(o);
	}

	public static List<Variable> modelsSourceContribution(ReadGraph graph, Resource sheet) throws DatabaseException {
		ArrayList<Variable> result = new ArrayList<Variable>();
		for(Resource r : graph.syncRequest(new ProjectModels(Simantics.getProjectResource()))) {
			result.add(Variables.getVariable(graph, r));
		}
		return result;
	}

	public static String modelsSourceContributionLabeler(ReadGraph graph, Variable variable) throws DatabaseException {
		return variable.getName(graph);
	}

}
