/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.spreadsheet.graph;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.spreadsheet.resource.SpreadsheetResource;

public class Ranges extends UnaryRead<Variable, Collection<Variable>> {

    public Ranges(Variable variable) {
        super(variable);
    }

    @Override
    public Collection<Variable> perform(ReadGraph graph) throws DatabaseException {
    	SpreadsheetResource SHEET = SpreadsheetResource.getInstance(graph);
    	ArrayList<Variable> result = new ArrayList<Variable>(); 
    	for(Variable child : parameter.getChildren(graph)) {
    		Resource type = child.getPossibleType(graph);
    		if(type != null) {
	    		if(graph.isInheritedFrom(type, SHEET.Range)) {
	    			result.add(child);
	    		}
    		}
    	}
    	return result;
    }

}
