/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.datatypes.utils.BTree;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.PossibleChild;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.AssumptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.VariableException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.ProxyVariables;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableSpaceManipulator;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteInterface;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.document.server.io.IColor;
import org.simantics.document.server.io.IFont;
import org.simantics.document.server.io.RGBColor;
import org.simantics.document.server.io.SimpleFont;
import org.simantics.layer0.Layer0;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.tuple.Tuple;
import org.simantics.spreadsheet.ClientModel;
import org.simantics.spreadsheet.OperationMode;
import org.simantics.spreadsheet.Range;
import org.simantics.spreadsheet.Spreadsheets;
import org.simantics.spreadsheet.Transaction;
import org.simantics.spreadsheet.common.TableCell;
import org.simantics.spreadsheet.common.cell.StringCellParser;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.utils.datastructures.Pair;

public class SpreadsheetUtils {
    public static Pair<String, Collection<VariableSpaceManipulator.PropertyCreationData>> parse(String text, StringCellParser[] parsers) {
        try {
            StringCellParser[] stringCellParserArray = parsers;
            int n = parsers.length;
            int n2 = 0;
            while (n2 < n) {
                StringCellParser parser = stringCellParserArray[n2];
                Collection<VariableSpaceManipulator.PropertyCreationData> parsed = parser.parse(text);
                if (parsed != null) {
                    return Pair.make((Object)parser.getType(), parsed);
                }
                ++n2;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }

    public static boolean isImmutable(Object object) {
        return !(object instanceof Resource) && !(object instanceof Variable);
    }

    public static String getLabel(ReadGraph graph, Object object) throws DatabaseException {
        if (object == null) {
            return "no data";
        }
        if (object instanceof Resource) {
            return NameUtils.getSafeName((ReadGraph)graph, (Resource)((Resource)object));
        }
        if (object instanceof Variable) {
            try {
                Object value = ((Variable)object).getValue(graph);
                return value.toString();
            }
            catch (VariableException variableException) {
                Object value = ((Variable)object).getPropertyValue(graph, "Label");
                return value.toString();
            }
        }
        if (object instanceof double[]) {
            return object.toString();
        }
        return object.toString();
    }

    private static String toString(Object object) {
        if (object instanceof double[]) {
            try {
                return Bindings.DOUBLE_ARRAY.toString(object);
            }
            catch (BindingException bindingException) {
                return object.toString();
            }
        }
        return object.toString();
    }

    public static String getContent(ReadGraph graph, Object object) throws DatabaseException {
        if (object == null) {
            return null;
        }
        if (object instanceof Resource) {
            SerialisationSupport support = (SerialisationSupport)graph.getService(SerialisationSupport.class);
            return support.getResourceSerializer().createRandomAccessId((Resource)object);
        }
        if (object instanceof Variable) {
            return ((Variable)object).getURI(graph);
        }
        return "";
    }

    public static void main(String[] args) {
        int i = 0;
        while (i < 16384) {
            String name = Spreadsheets.columnName((int)i);
            Range r = Spreadsheets.decodeCellAbsolute((String)(String.valueOf(name) + "1"));
            System.err.println(String.valueOf(i) + " " + name + " " + r);
            ++i;
        }
    }

    public static String getLabel(ClientModel model, int row, int column) {
        try {
            String location = Spreadsheets.cellName((int)row, (int)column);
            String label = (String)model.getPropertyAt(location, "label");
            if (label != null) {
                return label;
            }
            Variant content = SpreadsheetUtils.getSafeClientVariant(model, location, "content");
            if (content != null) {
                return SpreadsheetUtils.getContentString(content);
            }
            return null;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getContentString(Variant content) {
        return content.getValue().toString();
    }

    public static boolean isInBounds(String base, String location, int wBounds, int hBounds) {
        int hb;
        Range baseRange = Spreadsheets.decodeCellAbsolute((String)base);
        Range locationRange = Spreadsheets.decodeCellAbsolute((String)location);
        if (locationRange.startColumn < baseRange.startColumn) {
            return false;
        }
        if (locationRange.startRow < baseRange.startRow) {
            return false;
        }
        int wb = wBounds == -1 ? 0x2AAAAAAA : wBounds;
        int n = hb = hBounds == -1 ? 0x2AAAAAAA : hBounds;
        if (locationRange.startColumn > baseRange.startColumn + wb - 1) {
            return false;
        }
        return locationRange.startRow <= baseRange.startRow + hb - 1;
    }

    public static void schedule(Transaction<?> transaction, Write write) {
        if (transaction == null) {
            TransactionImpl impl = (TransactionImpl)SpreadsheetUtils.startTransaction(OperationMode.OPERATION);
            impl.add(write);
            impl.commit();
        } else {
            TransactionImpl impl = (TransactionImpl)transaction;
            impl.add(write);
        }
    }

    public static Transaction<Write> startTransaction() {
        return SpreadsheetUtils.startTransaction(OperationMode.EDIT_MODE);
    }

    public static Transaction<Write> startTransaction(OperationMode mode) {
        return new TransactionImpl(mode);
    }

    public static MutableVariant createVariant() {
        return new MutableVariant();
    }

    public static Variant getSafeClientVariant(ClientModel clientModel, String location, String property) {
        try {
            return (Variant)clientModel.getPossiblePropertyAt(location, property);
        }
        catch (Throwable t) {
            Logger.defaultLogError((Throwable)t);
            return Variant.ofInstance((Object)t.getMessage());
        }
    }

    public static Resource createSheet(WriteGraph graph, Resource book, String name) throws DatabaseException {
        return SpreadsheetUtils.createSheet(graph, book, name, new String[0], new int[0]);
    }

    public static Resource createSheet(WriteGraph graph, Resource book, String name, String[] colNames, int[] colWidths) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SpreadsheetResource sr = SpreadsheetResource.getInstance((ReadGraph)graph);
        Resource result = graph.newResource();
        graph.claim(result, L0.InstanceOf, null, sr.Spreadsheet);
        if (name == null) {
            name = NameUtils.findFreshEscapedName((ReadGraph)graph, (String)"Sheet", (Resource)book, (Resource)L0.ConsistsOf);
        }
        graph.claimLiteral(result, L0.HasName, L0.NameOf, L0.String, (Object)name, (Binding)Bindings.STRING);
        graph.claim(book, L0.ConsistsOf, L0.PartOf, result);
        BTree bt = new BTree(graph, 100, sr.Lines, sr.LineNode, L0.PartOf, false);
        Resource lines = bt.rootOfBTree();
        graph.claimLiteral(lines, L0.HasName, L0.NameOf, L0.String, (Object)"Lines", (Binding)Bindings.STRING);
        graph.claim(result, L0.ConsistsOf, L0.PartOf, lines);
        Resource newCell = graph.newResource();
        graph.claim(newCell, L0.InstanceOf, null, sr.Dimensions);
        graph.claimLiteral(newCell, L0.HasName, L0.NameOf, L0.String, (Object)"Dimensions", (Binding)Bindings.STRING);
        graph.addLiteral(newCell, sr.Dimensions_fitColumns, sr.Dimensions_fitColumns_Inverse, L0.Boolean, (Object)false, (Binding)Bindings.BOOLEAN);
        graph.addLiteral(newCell, sr.Dimensions_fitRows, sr.Dimensions_fitRows_Inverse, L0.Boolean, (Object)false, (Binding)Bindings.BOOLEAN);
        graph.addLiteral(newCell, sr.Dimensions_columnCount, sr.Dimensions_columnCount_Inverse, L0.Integer, (Object)128, (Binding)Bindings.INTEGER);
        graph.addLiteral(newCell, sr.Dimensions_rowCount, sr.Dimensions_rowCount_Inverse, L0.Integer, (Object)256, (Binding)Bindings.INTEGER);
        graph.claim(result, L0.ConsistsOf, L0.PartOf, newCell);
        newCell = graph.newResource();
        graph.claim(newCell, L0.InstanceOf, null, sr.Headers);
        graph.claimLiteral(newCell, L0.HasName, L0.NameOf, L0.String, (Object)"Headers", (Binding)Bindings.STRING);
        graph.addLiteral(newCell, sr.Headers_columnLabels, sr.Headers_columnLabels_Inverse, L0.StringArray, (Object)colNames, (Binding)Bindings.STRING_ARRAY);
        graph.addLiteral(newCell, sr.Headers_columnWidths, sr.Headers_columnWidths_Inverse, L0.IntegerArray, (Object)colWidths, (Binding)Bindings.INT_ARRAY);
        graph.claim(result, L0.ConsistsOf, L0.PartOf, newCell);
        return result;
    }

    public static Variable getBookVariable(ReadGraph graph, Resource book) throws DatabaseException {
        Variable variable = Variables.getVariable((ReadGraph)graph, (Resource)book);
        return ProxyVariables.makeProxyVariable((ReadGraph)graph, (Variable)variable, (Variable)variable);
    }

    public static Variable sheetRun(ReadGraph graph, Resource book, Variable context) throws DatabaseException {
        Variable root = Variables.getVariable((ReadGraph)graph, (Resource)book);
        return ProxyVariables.makeProxyVariable((ReadGraph)graph, (Variable)root, (Variable)context);
    }

    private static TableCell constructCell(int row, int column, Object data) {
        TableCell cell = new TableCell();
        cell.row = row;
        cell.column = column;
        cell.text = data.toString();
        return cell;
    }

    public static List<TableCell> queryCells(Object data) {
        ArrayList<TableCell> result = new ArrayList<TableCell>();
        if (data instanceof List) {
            List list = (List)data;
            int row = 0;
            for (Object o : list) {
                if (o instanceof Tuple) {
                    Tuple t = (Tuple)o;
                    int i = 0;
                    while (i < t.length()) {
                        result.add(SpreadsheetUtils.constructCell(row, i, t.get(i)));
                        ++i;
                    }
                } else if (o instanceof List) {
                    List rowList = (List)o;
                    int index = 0;
                    for (Object obj : rowList) {
                        result.add(SpreadsheetUtils.constructCell(row, index++, obj));
                    }
                } else {
                    result.add(SpreadsheetUtils.constructCell(row, 0, o));
                }
                ++row;
            }
        }
        return result;
    }

    public static List<TableCell> organizeCells(int columns, List<String> headers_, List<TableCell> cells) throws DatabaseException {
        ArrayList<TableCell> result = new ArrayList<TableCell>();
        int w = 0;
        int h = 0;
        if (columns < 2) {
            throw new AssumptionException("organizeCells: number of columns needs to be greater than 1");
        }
        for (TableCell cell : cells) {
            if (cell.column + 1 > w) {
                w = cell.column + 1;
            }
            if (cell.row <= h) continue;
            h = cell.row;
        }
        int fields = w - 1;
        if (columns > fields + 1) {
            columns = fields + 1;
        }
        int fieldsPerRow = columns - 1;
        int blocks = fields / fieldsPerRow;
        if (fields % fieldsPerRow > 0) {
            ++blocks;
        }
        TableCell[] names = new TableCell[h];
        TableCell[] headers = new TableCell[w];
        for (TableCell cell : cells) {
            if (cell.row == 0) {
                headers[cell.column] = cell;
                continue;
            }
            if (cell.column == 0) {
                names[cell.row - 1] = cell;
                continue;
            }
            TableCell copy = new TableCell(cell);
            int block = (copy.column - 1) / fieldsPerRow;
            copy.row = block * (h + 1) + copy.row;
            copy.column = 1 + (copy.column - 1) % fieldsPerRow;
            result.add(copy);
        }
        int j = 0;
        while (j < blocks) {
            int rowBase = j * (h + 1);
            int i = 0;
            while (i < h) {
                TableCell copy = new TableCell(names[i]);
                copy.row = rowBase + copy.row;
                result.add(copy);
                ++i;
            }
            TableCell legend = new TableCell(headers[0]);
            legend.row = rowBase;
            result.add(legend);
            int i2 = 1;
            while (i2 < columns) {
                int index = j * fieldsPerRow + i2;
                if (index < w) {
                    TableCell header = new TableCell(headers[index]);
                    header.row = rowBase;
                    header.column = i2;
                    result.add(header);
                }
                ++i2;
            }
            ++j;
        }
        return result;
    }

    public static List<TableCell> modifyCells1(List<TableCell> cells, Function1<TableCell, TableCell> fn) {
        ArrayList<TableCell> result = new ArrayList<TableCell>();
        for (TableCell cell : cells) {
            result.add((TableCell)fn.apply((Object)cell));
        }
        return result;
    }

    public static List<TableCell> modifyCells(List<TableCell> cells, List<Function1<TableCell, TableCell>> fns) {
        ArrayList<TableCell> result = new ArrayList<TableCell>();
        for (TableCell cell : cells) {
            for (Function1<TableCell, TableCell> fn : fns) {
                cell = (TableCell)fn.apply((Object)cell);
            }
            result.add(cell);
        }
        return result;
    }

    public static TableCell applyFont(IFont font, Function1<TableCell, Boolean> filter, TableCell cell) {
        if (!((Boolean)filter.apply((Object)cell)).booleanValue()) {
            return cell;
        }
        TableCell result = new TableCell(cell);
        result.font = font;
        return result;
    }

    public static TableCell applyAlign(int align, Function1<TableCell, Boolean> filter, TableCell cell) {
        if (!((Boolean)filter.apply((Object)cell)).booleanValue()) {
            return cell;
        }
        TableCell result = new TableCell(cell);
        result.align = align;
        return result;
    }

    public static TableCell applyForeground(IColor color, Function1<TableCell, Boolean> filter, TableCell cell) {
        if (!((Boolean)filter.apply((Object)cell)).booleanValue()) {
            return cell;
        }
        TableCell result = new TableCell(cell);
        result.foreground = color;
        return result;
    }

    public static TableCell applyBackground(IColor color, Function1<TableCell, Boolean> filter, TableCell cell) {
        if (!((Boolean)filter.apply((Object)cell)).booleanValue()) {
            return cell;
        }
        TableCell result = new TableCell(cell);
        result.background = color;
        return result;
    }

    public static IFont simpleFont(String family, String style, int height) {
        return new SimpleFont(family, style, height);
    }

    public static IColor rgbColor(int r, int g, int b) {
        return new RGBColor(r, g, b);
    }

    public static boolean selectRow(int row, TableCell cell) {
        return cell.row == row;
    }

    public static boolean selectColumn(int column, TableCell cell) {
        return cell.column == column;
    }

    public static void setSCLLine(WriteGraph graph, Resource spreadsheet, int row, String expression) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource lines = (Resource)graph.syncRequest((Read)new PossibleChild(spreadsheet, "Lines"));
        BTree bt = new BTree((ReadGraph)graph, lines);
        SpreadsheetResource SR = SpreadsheetResource.getInstance((ReadGraph)graph);
        Resource line = graph.newResource();
        graph.claim(line, L0.InstanceOf, SR.Line);
        graph.addLiteral(line, L0.HasName, L0.NameOf, (Object)("" + row), (Binding)Bindings.STRING);
        Layer0Utils.setExpression((WriteGraph)graph, (Resource)line, (Resource)SR.Line_content, null, (String)"[spreadsheetCell ]", (Resource)L0.SCLValue);
        bt.insertBTree(graph, Variant.ofInstance((Object)row), line);
    }

    public static String getFormattedLabel(ClientModel model, int row, int column, int formatIndex, String formatString) {
        block6: {
            String contentString;
            block7: {
                if (formatString == null) {
                    return SpreadsheetUtils.getLabel(model, row, column);
                }
                String location = Spreadsheets.cellName((int)row, (int)column);
                Variant content = SpreadsheetUtils.getSafeClientVariant(model, location, "content");
                if (content == null) break block6;
                contentString = SpreadsheetUtils.getContentString(content);
                if (!contentString.equals("~CIRCULAR~REF~")) break block7;
                return "0";
            }
            try {
                double value = Double.valueOf(contentString);
                if (Double.isNaN(value)) {
                    return SpreadsheetUtils.getLabel(model, row, column);
                }
                DataFormatter formatter = new DataFormatter();
                return formatter.formatRawCellContents(value, formatIndex, formatString);
            }
            catch (NumberFormatException numberFormatException) {
                return SpreadsheetUtils.getLabel(model, row, column);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    @Deprecated
    public static String cellName(int row, int column) {
        return Spreadsheets.cellName((int)row, (int)column);
    }

    @Deprecated
    public static String columnName(int column) {
        return Spreadsheets.columnName((int)column);
    }

    @Deprecated
    public static Range decodeCellAbsolute(String identifier) {
        return Spreadsheets.decodeCellAbsolute((String)identifier);
    }

    @Deprecated
    public static Range decodePossibleCellAbsolute(String identifier) {
        return Spreadsheets.decodePossibleCellAbsolute((String)identifier);
    }

    @Deprecated
    public static Range decodeRange(String rangeOrCell) {
        return Spreadsheets.decodeRange((String)rangeOrCell);
    }

    @Deprecated
    public static List<Range> decodeRanges(String ranges) {
        return Spreadsheets.decodeRanges((String)ranges);
    }

    @Deprecated
    public static int startColumn(List<Range> ranges) {
        return Spreadsheets.startColumn(ranges);
    }

    @Deprecated
    public static int startRow(List<Range> ranges) {
        return Spreadsheets.startRow(ranges);
    }

    @Deprecated
    public static String offset(String location, int rowOffset, int columnOffset) {
        return Spreadsheets.offset((String)location, (int)rowOffset, (int)columnOffset);
    }

    static class TransactionImpl
    implements Transaction<Write> {
        private ArrayList<Write> writes = new ArrayList();
        private final OperationMode mode;
        private Object context;
        private List<Object> needSync;

        public TransactionImpl(OperationMode mode) {
            this.mode = mode;
        }

        public void commit() {
            Simantics.async((WriteInterface)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    graph.markUndoPoint();
                    int i = 0;
                    while (i < writes.size()) {
                        Write write = (Write)writes.get(i);
                        try {
                            write.perform(graph);
                        }
                        catch (DatabaseException e) {
                            e.printStackTrace();
                            Logger.defaultLogError((Throwable)e);
                        }
                        ++i;
                    }
                    writes.clear();
                }
            });
        }

        public void add(Write write) {
            this.writes.add(write);
        }

        public boolean isOperationMode() {
            return this.mode.equals((Object)OperationMode.OPERATION);
        }

        public void setContext(Object context) {
            this.context = context;
        }

        public Object getContext() {
            return this.context;
        }

        public void needSynchronization(Object object) {
            if (this.needSync == null) {
                this.needSync = new ArrayList<Object>();
            }
            this.needSync.add(object);
        }

        public List<Object> needSynchronization() {
            return this.needSync;
        }
    }
}

