/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.spreadsheet.common.matrix;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.databoard.binding.mutable.Variant;

public class VariantMatrix {

	public int rows;
	public int columns;
	public Variant[] data;
	
	public VariantMatrix() {
		
	}
	
	public VariantMatrix(int rows, int columns) {
		this.rows = rows;
		this.columns = columns;
		this.data = new Variant[rows*columns];
	}

	public int getColumnCount() {
		return columns;
	}

	public int getRowCount() {
		return rows;
	}

	public Variant get(int row, int column) {
		return data[column*rows + row];
	}
	
	public void setColumn(int column, Collection<Variant> objects) {
		int index = rows*column;
		for(Variant o : objects) {
			data[index++] = o;
		}
	}

	public void set(int row, int column, Variant object) {
		data[rows*column + row] = object;
	}

	public Collection<Variant> getColumn(int column) {
		ArrayList<Variant> result = new ArrayList<Variant>();
		for(int i=0;i<rows;i++) {
			result.add(data[rows*column+i]);
		}
		return result;
	}

	public Collection<Variant> getRow(int row) {
		ArrayList<Variant> result = new ArrayList<Variant>();
		for(int i=0;i<columns;i++) {
			result.add(data[row + columns*i]);
		}
		return result;
	}
	
}
