/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics;

import org.eclipse.core.runtime.NullProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Tuukka Lehtonen
 */
public class TimingProgressMonitor extends NullProgressMonitor {

    private static final Logger LOGGER = LoggerFactory.getLogger(TimingProgressMonitor.class);

    private final long start;

    public TimingProgressMonitor() {
        this.start = System.nanoTime();
    }

    private void log(String msg) {
        LOGGER.info(msg + " @ " + (System.nanoTime() - start)*1e-9);
    }

    @Override
    public void worked(int work) {
        log("worked(" + work + ")");
    }

    @Override
    public void subTask(String name) {
        log("subTask(" + name + ")");
    }

    @Override
    public void setTaskName(String name) {
        log("setTaskName(" + name + ")");
    }

    @Override
    public void setCanceled(boolean value) {
        log("setCanceled(" + value+ ")");
        super.setCanceled(value);
    }

    @Override
    public boolean isCanceled() {
        log("isCanceled()");
        return super.isCanceled();
    }

    @Override
    public void internalWorked(double work) {
        log("internalWorked(" + work + ")");
    }

    @Override
    public void done() {
        log("done()");
    }

    @Override
    public void beginTask(String name, int totalWork) {
        log("beginTask(" + name + ", " + totalWork + ")");
    }

}