/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulation.ui.handlers.e4;

import java.text.ParseException;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;
import org.simantics.simulation.experiment.SimulationTimeUtil;
import org.simantics.simulation.ui.handlers.e4.TimeInputDialog;
import org.simantics.simulation.ui.handlers.e4.WorkbenchUtil;
import org.simantics.simulation.ui.preferences.SimulationPreferenceUtil;
import org.simantics.simulation.ui.preferences.SimulationPreferences;
import org.simantics.utils.ui.ExceptionUtils;

public class SetEndTime {
    private static final String SET_END_TIME_ITEM_ID = "org.simantics.simulation.ui.handledmenuitem.setendtime";
    @Inject
    private EModelService modelService;
    @Inject
    private IEventBroker eventBroker;

    @Execute
    public void execute(MMenuItem item) {
        if (!item.isSelected()) {
            return;
        }
        SimulationPreferences prefs = SimulationPreferenceUtil.getPrefs();
        TimeInputDialog dialog = new TimeInputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Set Simulation Step End Time", "simulation step end time", "" + prefs.stepEndTime);
        if (dialog.open() == 0) {
            try {
                double endTime = (Double)SimulationTimeUtil.getTimeFormat().parseObject(dialog.getValue());
                SimulationPreferenceUtil.flushPrefs(prefs.withEndTime(endTime).withStepMode(SimulationPreferences.StepMode.END_TIME));
                this.eventBroker.post("org/simantics/simulation/step/endTime", (Object)endTime);
                this.eventBroker.post("org/simantics/simulation/step/mode", (Object)SimulationPreferences.StepMode.END_TIME);
            }
            catch (BackingStoreException e) {
                ExceptionUtils.logAndShowError((Throwable)e);
            }
            catch (ParseException e) {
                ExceptionUtils.logAndShowError((Throwable)e);
            }
        } else {
            this.eventBroker.post("org/simantics/simulation/step/mode", (Object)prefs.stepMode);
        }
    }

    @Inject
    @Optional
    public void updateElement(@Optional @UIEventTopic(value="org/simantics/simulation/step/mode") SimulationPreferences.StepMode mode, MApplication application) {
        WorkbenchUtil.setMenuItemSelected(this.modelService, application, "org.simantics.simulation.ui.handledtoolitem.step", SET_END_TIME_ITEM_ID, mode == SimulationPreferences.StepMode.END_TIME);
    }
}

