/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulation.ui.handlers.e4;

import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;
import org.simantics.simulation.ui.handlers.e4.TimeInputDialog;
import org.simantics.simulation.ui.handlers.e4.WorkbenchUtil;
import org.simantics.simulation.ui.preferences.SimulationPreferenceUtil;
import org.simantics.simulation.ui.preferences.SimulationPreferences;
import org.simantics.utils.ui.ExceptionUtils;

public class SetDuration {
    private static final String SET_DURATION_ITEM_ID = "org.simantics.simulation.ui.handledmenuitem.setduration";
    @Inject
    private EModelService modelService;
    @Inject
    private IEventBroker eventBroker;

    @Execute
    public void execute(MMenuItem item) {
        if (!item.isSelected()) {
            return;
        }
        SimulationPreferences prefs = SimulationPreferenceUtil.getPrefs();
        TimeInputDialog dialog = new TimeInputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Set Simulation Step Duration", "simulation step duration", "" + prefs.stepDuration);
        if (dialog.open() == 0) {
            double duration = Double.parseDouble(dialog.getValue());
            try {
                SimulationPreferenceUtil.flushPrefs(prefs.withDuration(duration).withStepMode(SimulationPreferences.StepMode.DURATION));
                this.eventBroker.post("org/simantics/simulation/step/duration", (Object)duration);
                this.eventBroker.post("org/simantics/simulation/step/mode", (Object)SimulationPreferences.StepMode.DURATION);
            }
            catch (BackingStoreException e) {
                ExceptionUtils.logAndShowError((Throwable)e);
            }
        } else {
            this.eventBroker.post("org/simantics/simulation/step/mode", (Object)prefs.stepMode);
        }
    }

    @Inject
    @Optional
    public void updateElement(@Optional @UIEventTopic(value="org/simantics/simulation/step/mode") SimulationPreferences.StepMode mode, MApplication application) {
        WorkbenchUtil.setMenuItemSelected(this.modelService, application, "org.simantics.simulation.ui.handledtoolitem.step", SET_DURATION_ITEM_ID, mode == SimulationPreferences.StepMode.DURATION);
    }
}

