/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.selectionview;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.IPageSite;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.common.views.IFilterArea;
import org.simantics.browsing.ui.common.views.IFilterAreaProvider;
import org.simantics.db.ReadGraph;
import org.simantics.selectionview.IPropertyTab;
import org.simantics.selectionview.SelectionProcessor;
import org.simantics.selectionview.SelectionProcessorBinding;
import org.simantics.selectionview.SelectionProcessorBindingExtensionManager;
import org.simantics.selectionview.TabbedPropertyTable;

public class StandardProperties
extends TabbedPropertyTable
implements IFilterAreaProvider,
IPropertyTab {
    public StandardProperties(IWorkbenchPartSite site, IPageSite pageSite, Composite parent, int style, Set<String> browseContexts, Collection<SelectionProcessor<?, ?>> selectionProcessors) {
        super(site, pageSite, parent, style);
        final HashSet processors = new HashSet();
        if (selectionProcessors != null) {
            processors.addAll(selectionProcessors);
        }
        for (SelectionProcessorBinding binding : SelectionProcessorBindingExtensionManager.getInstance().getBoundContributions(browseContexts)) {
            processors.add(binding.getProcessor());
        }
        this.setSelectionProcessor(new SelectionProcessor<Object, ReadGraph>(){

            @Override
            public Collection<?> process(Object selection, ReadGraph graph) {
                HashSet l = new HashSet();
                for (SelectionProcessor p : processors) {
                    Collection<?> c = p.process(selection, graph);
                    if (c != null) {
                        l.addAll(c);
                        continue;
                    }
                    ErrorLogger.defaultLogWarning((String)("SelectionProcessor '" + p + "' invalidly returned null with selection '" + selection + "'"), null);
                }
                return l;
            }
        });
    }

    public IFilterArea getFilterArea() {
        IPropertyTab active = this.getActiveTab();
        if (!(active instanceof IFilterAreaProvider)) {
            return null;
        }
        return ((IFilterAreaProvider)active).getFilterArea();
    }
}

