package org.simantics.selectionview;

import java.util.HashMap;
import java.util.Map;

import org.simantics.browsing.ui.model.labels.LabelRule;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;

public class VariablePropertyLabelRule implements LabelRule {
	
    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Variable.class);
    }

    @Override
    public Map<String, String> getLabel(ReadGraph graph, Object content)
            throws DatabaseException {
    	
    	Variable variable = (Variable)content;
    	
    	Map<String, String> result = new HashMap<String, String>();
    	
    	for(Variable property : variable.getProperties(graph)) {
    		String column = property.getPossiblePropertyValue(graph, Variables.DISPLAY_COLUMN);
    		if(column != null) {
        		String value = property.getPossibleValue(graph, Bindings.STRING);
        		if (value != null)
        			result.put(column, value);
    		}
    	}
    	
		return result;
		
    }

}
