/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.modulebrowser;

import gnu.trove.map.hash.THashMap;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.ui.editor2.OpenSCLModule;
import org.simantics.scl.ui.modulebrowser.CreateModuleAction;
import org.simantics.scl.ui.modulebrowser.CreateModuleValidator;
import org.simantics.scl.ui.modulebrowser.Messages;
import org.simantics.scl.ui.modulebrowser.PluginSelectionDialog;
import org.simantics.scl.ui.modulebrowser.SCLModuleBrowser;

public class CreateModuleDialog
extends Dialog {
    SCLModuleBrowser parentBrowser;
    String initialPackageName = "";
    String initialPluginName = "";
    Text packageName;
    Text moduleName;
    Text pluginName;
    private THashMap<String, Bundle> bundles;
    private Color normalBackground;
    private Color errorBackground;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            CreateModuleDialog.this.validate();
        }
    };

    protected CreateModuleDialog(Shell parentShell, SCLModuleBrowser parentBrowser) {
        super(parentShell);
        this.parentBrowser = parentBrowser;
        this.setShellStyle(2096);
        this.bundles = CreateModuleAction.findGoodBundles();
        this.normalBackground = parentShell.getDisplay().getSystemColor(1);
        this.errorBackground = new Color((Device)parentShell.getDisplay(), 255, 128, 128);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.CreateModuleDialog_CreateNewModule);
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CreateModuleDialog.this.errorBackground.dispose();
            }
        });
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.fillDefaults().margins(10, 10).numColumns(2).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        Label packageNameLabel = new Label(composite, 0);
        packageNameLabel.setText(Messages.CreateModuleDialog_Package);
        GridDataFactory.fillDefaults().applyTo((Control)packageNameLabel);
        this.packageName = new Text(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).minSize(500, -1).applyTo((Control)this.packageName);
        this.packageName.setText(this.initialPackageName);
        this.packageName.addModifyListener(this.modifyListener);
        Label moduleNameLabel = new Label(composite, 0);
        moduleNameLabel.setText(Messages.CreateModuleDialog_ModuleName);
        GridDataFactory.fillDefaults().applyTo((Control)moduleNameLabel);
        this.moduleName = new Text(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.moduleName);
        this.moduleName.addModifyListener(this.modifyListener);
        Label pluginNameLabel = new Label(composite, 0);
        pluginNameLabel.setText(Messages.CreateModuleDialog_Plugin);
        GridDataFactory.fillDefaults().applyTo((Control)pluginNameLabel);
        Composite pluginNameComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)pluginNameComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(pluginNameComposite);
        this.pluginName = new Text(pluginNameComposite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.pluginName);
        this.pluginName.setText(this.initialPluginName);
        this.pluginName.addModifyListener(this.modifyListener);
        Button browsePlugins = new Button(pluginNameComposite, 8);
        browsePlugins.setText(Messages.CreateModuleDialog_Browse);
        GridDataFactory.fillDefaults().applyTo((Control)browsePlugins);
        browsePlugins.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateModuleDialog.this.browsePlugins();
            }
        });
        this.moduleName.setFocus();
        parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                CreateModuleDialog.this.validate();
            }
        });
        return composite;
    }

    private void browsePlugins() {
        PluginSelectionDialog.Entry result;
        ArrayList<PluginSelectionDialog.Entry> entries = new ArrayList<PluginSelectionDialog.Entry>(this.bundles.size());
        String currentPackageName = this.packageName.getText();
        for (Bundle bundle : this.bundles.values()) {
            entries.add(new PluginSelectionDialog.Entry(bundle, CreateModuleAction.packageMatchLength(bundle, currentPackageName)));
        }
        PluginSelectionDialog dialog = new PluginSelectionDialog(this.getShell(), entries);
        if (dialog.open() == 0 && (result = (PluginSelectionDialog.Entry)dialog.getFirstResult()) != null) {
            this.pluginName.setText(result.bundle.getSymbolicName());
            this.validate();
        }
    }

    private void validate() {
        boolean validPackageName = CreateModuleValidator.isValidPackageName(this.packageName.getText());
        this.packageName.setBackground(validPackageName ? this.normalBackground : this.errorBackground);
        boolean validModuleName = CreateModuleValidator.isValidModuleName(this.moduleName.getText());
        if (validModuleName && validPackageName) {
            String fullModuleName = String.valueOf(this.packageName.getText()) + "/" + this.moduleName.getText();
            validModuleName = SCLOsgi.SOURCE_REPOSITORY.getModuleSource(fullModuleName, null) == null;
        }
        this.moduleName.setBackground(validModuleName ? this.normalBackground : this.errorBackground);
        boolean validPluginName = this.bundles.containsKey((Object)this.pluginName.getText());
        this.pluginName.setBackground(validPluginName ? this.normalBackground : this.errorBackground);
        this.getButton(0).setEnabled(validPackageName && validModuleName && validPackageName);
    }

    public void setPackage(String initialPackageName) {
        this.initialPackageName = initialPackageName;
        this.initialPluginName = CreateModuleAction.findBestPlugin(this.bundles, initialPackageName);
    }

    protected void okPressed() {
        try {
            Bundle bundle = (Bundle)this.bundles.get((Object)this.pluginName.getText());
            if (bundle != null) {
                CreateModuleAction.createModule(bundle, this.packageName.getText(), this.moduleName.getText());
                this.parentBrowser.refresh();
                OpenSCLModule.scheduleOpenModule(String.valueOf(this.packageName.getText()) + "/" + this.moduleName.getText());
            }
        }
        catch (IOException e) {
            ErrorDialog.openError((Shell)this.getParentShell(), (String)"Module creation failed", (String)e.getMessage(), (IStatus)new Status(4, "org.simantics.scl.ui", e.getMessage()));
        }
        super.okPressed();
    }
}

