package org.simantics.scl.runtime.list;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;

public class ShareableList<T> extends AbstractList<T> {

    public static final int INITIAL_CAPACITY = 4;
    
    T[] elements;
    int size;
    boolean head;
    
    public ShareableList(T[] elements, int size, boolean head) {
        this.elements = elements;
        this.size = size;
        this.head = head;
    }
    
    @SuppressWarnings("unchecked")
    public ShareableList() {
        this.elements = (T[])new Object[INITIAL_CAPACITY];
        this.size = 0;
        this.head = true;
    }

    @Override
    public T get(int index) {
        if(index < 0 || index >= size)
            throw new IndexOutOfBoundsException();
        return elements[index];
    }

    @Override
    public int size() {
        return size;
    }

    @SuppressWarnings("unchecked")
    public ShareableList<T> append(T element) {
        T[] newElements;
        if(size < elements.length) {            
            if(head) {
                head = false;
                newElements = elements;
            }
            else {
                newElements = (T[])new Object[elements.length];
                System.arraycopy(elements, 0, newElements, 0, size);
            }
        }
        else {
            newElements = Arrays.copyOf(elements, (elements.length*3)/2 + 1);            
        }
        newElements[size] = element;
        return new ShareableList<T>(newElements, size+1, true);
    }
    
    @SuppressWarnings("unchecked")
    public ShareableList<T> appendAll(List<T> xs) {
        int count = xs.size();
        int size = this.size;
        int newSize = size + count;
        
        T[] newElements;
        if(newSize <= elements.length) {            
            if(head) {
                head = false;
                newElements = elements;
            }
            else {
                newElements = (T[])new Object[elements.length];
                System.arraycopy(elements, 0, newElements, 0, size);
            }
        }
        else {
            newElements = Arrays.copyOf(elements, Math.max((elements.length*3)/2 + 1, newSize));            
        }
        for(int i=0;i<count;++i)
            newElements[i+size] = xs.get(i);
        return new ShareableList<T>(newElements, newSize, true);
    }
    
    @SuppressWarnings("unchecked")
    public static <T> List<T> add(List<T> list, T element) {
        List<T> result;
        if(list instanceof ShareableList)
            result = ((ShareableList<T>)list).append(element);
        else {
            int size = list.size();
            T[] newElements = (T[])new Object[(size*3)/2 + 1];
            for(int i=0;i<size;++i)
                newElements[i] = list.get(i);
            newElements[size] = element;
            result = new ShareableList<T>(newElements, size+1, true);
        }
        //System.out.println(list + " + " + element + " = " + result);
        return result;
    }
    
    @SuppressWarnings("unchecked")
    public static <T> List<T> concat(List<T> a, List<T> b) {
        List<T> result;
        if(a instanceof ShareableList)
            result = ((ShareableList<T>)a).appendAll(b);
        else {
            int aSize = a.size();
            int bSize = b.size();
            int size = aSize + bSize;
            T[] newElements = (T[])new Object[(size*3)/2 + 1];
            for(int i=0;i<aSize;++i)
                newElements[i] = a.get(i);
            for(int i=0;i<bSize;++i)
                newElements[aSize + i] = b.get(i);
            result = new ShareableList<T>(newElements, size, true);
        }
        //System.out.println(a + " + " + b + " = " + result);
        return result;
    }
    
}
