package org.simantics.scl.reflection.tests;

import static junit.framework.Assert.*;
import static org.simantics.scl.compiler.types.Types.parseType;

import java.util.ArrayList;
import java.util.List;

import org.junit.Test;
import org.simantics.scl.reflection.MinimalTypeBindingScheme;
import org.simantics.scl.reflection.ReflectionUtils;
import org.simantics.scl.reflection.TypeBindingScheme;
import org.simantics.scl.runtime.function.Function;

public class TestReflectionUtils {

    @Test
    public void testReflectionUtils() throws Exception {
        TypeBindingScheme s = MinimalTypeBindingScheme.INSTANCE;        
        
        Class<?> c = getClass();
        
        assertTrue(ReflectionUtils.isAssignableFrom(s, parseType("Integer"), Integer.class));
        assertTrue(ReflectionUtils.isAssignableFrom(s, parseType("Integer"), int.class));
        assertTrue(ReflectionUtils.isAssignableFrom(s, parseType("String"), String.class));
        assertTrue(ReflectionUtils.isAssignableFrom(s, parseType("[String]"), List.class));
        assertTrue(ReflectionUtils.isAssignableFrom(s, parseType("[String]"), ArrayList.class));
        assertTrue(ReflectionUtils.isAssignableFrom(s, List.class, parseType("[String]")));
        assertFalse(ReflectionUtils.isAssignableFrom(s, ArrayList.class, parseType("[String]")));
        assertTrue(ReflectionUtils.isAssignableFrom(s, parseType("String -> String"), 
                Function.class));
        assertTrue(ReflectionUtils.isCompatible(s, parseType("String -> Integer"), 
                c.getMethod("method1", String.class)));
        assertTrue(ReflectionUtils.isCompatible(s, parseType("String -> ()"), 
                c.getMethod("method2", String.class)));
        assertTrue(ReflectionUtils.isCompatible(s, parseType("Integer"), 
                c.getMethod("method3")));
        
        assertFalse(ReflectionUtils.isAssignableFrom(s, parseType("String"), Integer.class));
        
    }
    
    public static int method1(String a) {
        return a.length();
    }
    
    public static void method2(String a) {
        System.out.println(a);
    }
    
    public static int method3() {
        return 3;
    }
}
