/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.osgi.internal;

import java.util.Hashtable;
import java.util.concurrent.ForkJoinPool;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.simantics.scl.compiler.errors.Failable;
import org.simantics.scl.compiler.module.repository.ModuleRepository;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.compiler.source.repository.ModuleSourceRepository;
import org.simantics.scl.compiler.source.repository.ProceduralModuleSourceRepository;
import org.simantics.scl.compiler.source.repository.SourceRepositories;
import org.simantics.scl.osgi.SCLOsgi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Activator.class);
    public static final String PLUGIN_ID = "org.simantics.scl.osgi";
    private static BundleContext context;

    public static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        Hashtable properties = new Hashtable();
        bundleContext.registerService(ModuleSourceRepository.class, (Object)SourceRepositories.BUILTIN_SOURCE_REPOSITORY, properties);
        bundleContext.registerService(ModuleSourceRepository.class, (Object)new ProceduralModuleSourceRepository(){

            protected ModuleRepository getModuleRepository(UpdateListener listener) {
                return SCLOsgi.MODULE_REPOSITORY;
            }
        }, properties);
        LOGGER.info("Warming up SCL-compiler with StandardLibrary");
        ForkJoinPool.commonPool().submit(() -> {
            Failable module = SCLOsgi.MODULE_REPOSITORY.getModule("StandardLibrary");
            LOGGER.info("StandardLibrary compiled {}", (Object)module);
        });
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
    }
}

