package org.simantics.scl.osgi.internal;

import java.io.File;
import java.net.URL;

import org.eclipse.core.runtime.FileLocator;
import org.osgi.framework.Bundle;

public class BundleUtils {
	
	/**
	 * Attempt to find the given entry from the given bundle.
	 * 
	 * This method looks for the entry in all bundles that have the appropriate
	 * symbolic name and returns the first result.
	 * 
	 * @param bundle name of the bundle
	 * @param entry name of the entry
	 * @return URL of the entry or null if not found
	 */
	public static URL getEntryFromBundle(String bundle, String entry) {
		for (Bundle b : Activator.getContext().getBundles()) {
			if (b.getSymbolicName().equals(bundle)) {
				URL e = b.getEntry(entry);
				if (e != null)
					return e; 
			}
		}
		return null;
	}
	
	/**
	 * Find the file that corresponds to the given URL.
	 * 
	 * Note that this method does not work if the url points inside a bundle 
	 * which is compiled into a jar file.
	 * 
	 * @param url URL of a file (obtained with getEntryFromBundle or otherwise, 
	 *            must actually be a file)
	 * @return File object that corresponds to the given URL
	 */
	public static File getFileFromURL(URL url) {
		try {
			return new File(FileLocator.toFileURL(url).toURI());
		}
		catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	public static String resolveBundleState(Bundle bundle) {
		switch (bundle.getState()) {
		case Bundle.UNINSTALLED: return "UNINSTALLED";
		case Bundle.INSTALLED: return "INSTALLED";
		case Bundle.RESOLVED: return "RESOLVED";
		case Bundle.STARTING: return "STARTING";
		case Bundle.STOPPING: return "STOPPING";
		case Bundle.ACTIVE: return "ACTIVE";
		default: return "UNKNOWN";
		}
	}

}
