/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.types.util;

import java.util.ArrayList;
import org.simantics.scl.compiler.types.Skeletons;
import org.simantics.scl.compiler.types.TApply;
import org.simantics.scl.compiler.types.TForAll;
import org.simantics.scl.compiler.types.TFun;
import org.simantics.scl.compiler.types.TMetaVar;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.Type;

public abstract class TypeListener {
    private ArrayList<TMetaVar.TMetaVarListener> metaVarListeners = new ArrayList(2);

    public abstract void notifyAboutChange();

    public void listenSkeleton(Type type) {
        if ((type = Skeletons.canonicalSkeleton(type)) instanceof TMetaVar) {
            TMetaVar metaVar = (TMetaVar)type;
            TMetaVar.TMetaVarListener latestListener = metaVar.getLatestListener();
            if (latestListener instanceof SubListener && ((SubListener)latestListener).parent == this) {
                return;
            }
            SubListener subListener = new SubListener(this);
            this.metaVarListeners.add(subListener);
            metaVar.addListener(subListener);
        } else if (type instanceof TApply) {
            TApply apply = (TApply)type;
            this.listenSkeleton(apply.function);
            this.listenSkeleton(apply.parameter);
        } else if (type instanceof TFun) {
            TFun fun = (TFun)type;
            this.listenSkeleton(fun.domain);
            this.listenSkeleton(fun.range);
        } else if (type instanceof TForAll) {
            TForAll forAll = (TForAll)type;
            this.listenSkeleton(forAll.type);
        } else if (type instanceof TPred) {
            TPred pred = (TPred)type;
            Type[] typeArray = pred.parameters;
            int n = pred.parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Type parameter = typeArray[n2];
                this.listenSkeleton(parameter);
                ++n2;
            }
        }
    }

    private static class SubListener
    extends TMetaVar.TMetaVarListener {
        private final TypeListener parent;

        public SubListener(TypeListener parent) {
            this.parent = parent;
        }

        @Override
        public void notifyAboutChange() {
            for (TMetaVar.TMetaVarListener otherListeners : this.parent.metaVarListeners) {
                otherListeners.remove();
            }
            this.parent.notifyAboutChange();
        }
    }
}

