/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.parser.generator.table;

import java.util.Arrays;
import java.util.Collection;
import org.simantics.scl.compiler.parser.generator.grammar.AnaGrammar;
import org.simantics.scl.compiler.parser.generator.table.Item;

public class ItemSet {
    public final Item[] items;
    int hash;
    private static final int PROD = 961;

    public ItemSet(Item[] items) {
        this.items = items;
        Arrays.sort(items);
    }

    public ItemSet(Collection<Item> items) {
        this(items.toArray(new Item[items.size()]));
    }

    public int hashCode() {
        if (this.hash == 0) {
            int h = 1;
            Item[] itemArray = this.items;
            int n = this.items.length;
            int n2 = 0;
            while (n2 < n) {
                Item item = itemArray[n2];
                h = 961 * h + item.hashCode();
                ++n2;
            }
            this.hash = h;
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ItemSet other = (ItemSet)obj;
        if (other.items.length != this.items.length) {
            return false;
        }
        int i = 0;
        while (i < this.items.length) {
            if (!this.items[i].equals(other.items[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString(AnaGrammar grammar) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        Item[] itemArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            Item item = itemArray[n2];
            if (first) {
                first = false;
            } else {
                b.append('\n');
            }
            b.append("    ").append(item.toString(grammar));
            ++n2;
        }
        return b.toString();
    }
}

