/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.elaboration.subsumption2;

import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.internal.types.effects.EffectIdMap;
import org.simantics.scl.compiler.types.TMetaVar;
import org.simantics.scl.compiler.types.exceptions.UnificationException;
import org.simantics.scl.compiler.types.util.Polarity;

public class SubsumptionGraph {
    public static final int REMOVED = 0x7FFFFFFE;

    public static class LowerBoundSource {
        public final long location;
        public final int lower;
        public final LowerBoundSource next;

        public LowerBoundSource(long location, int lower, LowerBoundSource next) {
            this.location = location;
            this.lower = lower;
            this.next = next;
        }
    }

    public static abstract class Node {
        int lowerBound = 0;
        int upperBound = -1;
        Sub lower;
        LowerBoundSource lowerBoundSource;

        public void addLowerBoundSource(long location, int lower) {
            this.lowerBoundSource = new LowerBoundSource(location, lower, this.lowerBoundSource);
        }
    }

    public static class PartOfUnion {
        VarNode a;
        UnionNode b;
        PartOfUnion aNext;
        PartOfUnion aPrev;
        PartOfUnion bNext;
        PartOfUnion bPrev;

        public PartOfUnion(VarNode a, UnionNode b) {
            this.a = a;
            this.b = b;
            this.aNext = a.partOf;
            if (this.aNext != null) {
                this.aNext.aPrev = this;
            }
            a.partOf = this;
            this.bNext = b.parts;
            if (this.bNext != null) {
                this.bNext.bPrev = this;
            }
            b.parts = this;
        }

        public void detachA() {
            if (this.aNext != null) {
                this.aNext.aPrev = this.aPrev;
            }
            if (this.aPrev != null) {
                this.aPrev.aNext = this.aNext;
            } else {
                this.a.partOf = this.aNext;
            }
        }

        public void detachB() {
            if (this.bNext != null) {
                this.bNext.bPrev = this.bPrev;
            }
            if (this.bPrev != null) {
                this.bPrev.bNext = this.bNext;
            } else {
                this.b.parts = this.bNext;
            }
        }

        public void remove() {
            this.detachA();
            this.detachB();
        }
    }

    public static class Sub {
        VarNode a;
        Node b;
        Sub aNext;
        Sub aPrev;
        Sub bNext;
        Sub bPrev;

        public Sub(VarNode a, Node b) {
            this.a = a;
            this.b = b;
            this.aNext = a.upper;
            if (this.aNext != null) {
                this.aNext.aPrev = this;
            }
            a.upper = this;
            this.bNext = b.lower;
            if (this.bNext != null) {
                this.bNext.bPrev = this;
            }
            b.lower = this;
        }

        public void detachA() {
            if (this.aNext != null) {
                this.aNext.aPrev = this.aPrev;
            }
            if (this.aPrev != null) {
                this.aPrev.aNext = this.aNext;
            } else {
                this.a.upper = this.aNext;
            }
        }

        public void detachB() {
            if (this.bNext != null) {
                this.bNext.bPrev = this.bPrev;
            }
            if (this.bPrev != null) {
                this.bPrev.bNext = this.bNext;
            } else {
                this.b.lower = this.bNext;
            }
        }

        public void remove() {
            this.detachA();
            this.detachB();
        }
    }

    public static class UnionNode
    extends Node {
        long location;
        PartOfUnion parts;
        int constPart;

        public UnionNode(long location, int constPart) {
            this.location = location;
            this.constPart = constPart;
            this.lowerBound = constPart;
        }

        public void remove() {
            Object cur = this.lower;
            while (cur != null) {
                ((Sub)cur).detachA();
                cur = ((Sub)cur).bNext;
            }
            cur = this.parts;
            while (cur != null) {
                ((PartOfUnion)cur).detachA();
                cur = ((PartOfUnion)cur).bNext;
            }
            this.constPart = 0x7FFFFFFE;
        }
    }

    public static class VarNode
    extends Node {
        TMetaVar origin;
        Sub upper;
        PartOfUnion partOf;
        int index;

        public VarNode(TMetaVar origin) {
            this.origin = origin;
        }

        public Polarity getPolarity() {
            return this.origin.getPolarity();
        }

        public void replaceBy(VarNode replacement) {
            try {
                this.origin.setRef(replacement.origin);
            }
            catch (UnificationException e) {
                throw new InternalCompilerError(e);
            }
            Object last = null;
            Object cur = this.upper;
            while (cur != null) {
                ((Sub)cur).a = replacement;
                last = cur;
                cur = ((Sub)cur).aNext;
            }
            if (last != null) {
                ((Sub)last).aNext = replacement.upper;
                if (((Sub)last).aNext != null) {
                    ((Sub)last).aNext.aPrev = last;
                }
                replacement.upper = this.upper;
            }
            last = null;
            cur = this.lower;
            while (cur != null) {
                ((Sub)cur).b = replacement;
                last = cur;
                cur = ((Sub)cur).bNext;
            }
            if (last != null) {
                ((Sub)last).bNext = replacement.lower;
                if (((Sub)last).bNext != null) {
                    ((Sub)last).bNext.bPrev = last;
                }
                replacement.lower = this.lower;
            }
            last = null;
            cur = this.partOf;
            while (cur != null) {
                ((PartOfUnion)cur).a = replacement;
                last = cur;
                cur = ((PartOfUnion)cur).bNext;
            }
            if (last != null) {
                ((PartOfUnion)last).aNext = replacement.partOf;
                if (((PartOfUnion)last).aNext != null) {
                    ((PartOfUnion)last).aNext.bPrev = last;
                }
                replacement.partOf = this.partOf;
            }
            this.index = 0x7FFFFFFE;
        }

        public void removeConstantNode(EffectIdMap effectIds, int constValue) {
            try {
                this.origin.setRef(effectIds.toType(constValue));
            }
            catch (UnificationException e) {
                throw new InternalCompilerError(e);
            }
            Object cur = this.lower;
            while (cur != null) {
                ((Sub)cur).detachA();
                cur = ((Sub)cur).bNext;
            }
            cur = this.upper;
            while (cur != null) {
                ((Sub)cur).detachB();
                cur = ((Sub)cur).aNext;
            }
            cur = this.partOf;
            while (cur != null) {
                ((PartOfUnion)cur).detachB();
                ((PartOfUnion)cur).b.constPart |= constValue;
                cur = ((PartOfUnion)cur).aNext;
            }
            this.index = 0x7FFFFFFE;
        }
    }
}

