/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.elaboration.constraints;

import java.util.ArrayList;
import org.simantics.scl.compiler.elaboration.expressions.ELambda;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLambda;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLet;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.internal.elaboration.constraints.Constraint;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class ExpressionAugmentation {
    private static Expression augmentSolvedAux(ArrayList<Constraint> solved, Expression expression) {
        long loc = expression.getLocation();
        int i = solved.size() - 1;
        while (i >= 0) {
            Constraint c = solved.get(i);
            Type type = expression.getType();
            expression = new ESimpleLet(loc, c.evidence, c.generate(loc), expression);
            expression.setType(type);
            --i;
        }
        return expression;
    }

    public static Expression augmentSolved(ArrayList<Constraint> solved, Expression expression) {
        if (expression instanceof ELambda) {
            expression = expression.decomposeMatching();
        }
        if (expression instanceof ESimpleLambda) {
            ESimpleLambda cur = (ESimpleLambda)expression;
            while (cur.value instanceof ESimpleLambda) {
                cur = (ESimpleLambda)cur.value;
            }
            cur.value = ExpressionAugmentation.augmentSolvedAux(solved, cur.value);
        } else {
            expression = ExpressionAugmentation.augmentSolvedAux(solved, expression);
        }
        return expression;
    }

    public static Expression augmentUnsolved(ArrayList<Constraint> unsolved, Expression expression) {
        long loc = expression.getLocation();
        int i = unsolved.size() - 1;
        while (i >= 0) {
            Constraint c = unsolved.get(i);
            Type type = expression.getType();
            expression = new ESimpleLambda(loc, c.evidence, expression);
            expression.setType(Types.constrained(c.constraint, type));
            --i;
        }
        return expression;
    }
}

