/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.codegen.chr;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.cojen.classfile.TypeDesc;
import org.objectweb.asm.Label;
import org.simantics.scl.compiler.elaboration.chr.CHRRule;
import org.simantics.scl.compiler.elaboration.chr.CHRRuleset;
import org.simantics.scl.compiler.elaboration.chr.plan.CHRSearchPlan;
import org.simantics.scl.compiler.elaboration.chr.relations.CHRConstraint;
import org.simantics.scl.compiler.internal.codegen.chr.CHRCodeGenerationConstants;
import org.simantics.scl.compiler.internal.codegen.utils.ClassBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.LocalVariable;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilderBase;

public class CHRPriorityFactContainerCodeGenerator
implements CHRCodeGenerationConstants {
    ClassBuilder storeClassBuilder;
    String containerClassName;
    private TypeDesc containerTypeDesc;
    private ClassBuilder classBuilder;
    private TypeDesc storeTypeDesc;
    private CHRRuleset ruleset;
    private CHRRule rule;

    public CHRPriorityFactContainerCodeGenerator(ClassBuilder storeClassBuilder, CHRRuleset ruleset, CHRRule rule) {
        this.storeClassBuilder = storeClassBuilder;
        this.containerClassName = String.valueOf(storeClassBuilder.getClassName()) + "$" + "CHRPriorityFactContainer" + rule.priority;
        this.containerTypeDesc = TypeDesc.forClass(this.containerClassName);
        this.classBuilder = new ClassBuilder(storeClassBuilder.getModuleBuilder(), 1, this.containerClassName, "org/simantics/scl/runtime/chr/CHRPriorityFactContainer", new String[0]);
        this.storeTypeDesc = storeClassBuilder.getType();
        this.ruleset = ruleset;
        this.rule = rule;
    }

    public void generate() {
        this.generateFields();
        this.generateContructor();
        THashMap planMap = new THashMap();
        for (CHRSearchPlan plan : this.rule.plans) {
            ArrayList<CHRSearchPlan> list = (ArrayList<CHRSearchPlan>)planMap.get((Object)plan.constraint);
            if (list == null) {
                list = new ArrayList<CHRSearchPlan>(4);
                planMap.put((Object)plan.constraint, list);
            }
            list.add(plan);
        }
        planMap.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<CHRConstraint, ArrayList<CHRSearchPlan>>(){

            public boolean execute(CHRConstraint constraint, ArrayList<CHRSearchPlan> plans) {
                int i = 0;
                while (i < plans.size()) {
                    CHRPriorityFactContainerCodeGenerator.this.generateActivate(constraint, plans.get(i), i);
                    ++i;
                }
                return true;
            }
        });
        this.generateActivate((THashMap<CHRConstraint, ArrayList<CHRSearchPlan>>)planMap);
        this.classBuilder.getModuleBuilder().addClass(this.classBuilder);
    }

    private void generateContructor() {
        MethodBuilderBase mb = this.classBuilder.addConstructorBase(1, new TypeDesc[]{this.storeTypeDesc});
        mb.loadThis();
        mb.loadConstant(this.rule.priority + this.ruleset.initialPriorityNumber);
        mb.invokeSuperConstructor(new TypeDesc[]{TypeDesc.INT});
        mb.loadThis();
        mb.loadLocal(mb.getParameter(0));
        mb.storeField(this.containerClassName, "parent", this.storeTypeDesc);
        mb.returnVoid();
        mb.finish();
    }

    private void generateFields() {
        this.classBuilder.addField(1, "parent", this.storeTypeDesc);
    }

    private void generateActivate(THashMap<CHRConstraint, ArrayList<CHRSearchPlan>> planMap) {
        final MethodBuilderBase mb = this.classBuilder.addMethodBase(1, "activate", TypeDesc.VOID, new TypeDesc[]{CHRContext, CHRFact});
        final Label finishLabel = mb.createLabel();
        final AtomicReference nextLabel = new AtomicReference();
        planMap.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<CHRConstraint, ArrayList<CHRSearchPlan>>(){

            public boolean execute(CHRConstraint constraint, ArrayList<CHRSearchPlan> plans) {
                int nextPriority = CHRPriorityFactContainerCodeGenerator.this.ruleset.getAndUpdateNextPriority(constraint, ((CHRPriorityFactContainerCodeGenerator)CHRPriorityFactContainerCodeGenerator.this).rule.priority);
                Label next = (Label)nextLabel.get();
                if (next != null) {
                    mb.setLocation(next);
                }
                mb.loadLocal(mb.getParameter(1));
                mb.instanceOf(constraint.factTypeDesc);
                next = mb.createLabel();
                nextLabel.set(next);
                mb.ifZeroComparisonBranch(next, "==");
                int id = 0;
                while (id < plans.size()) {
                    mb.loadThis();
                    mb.loadLocal(mb.getParameter(0));
                    mb.loadLocal(mb.getParameter(1));
                    mb.checkCast(constraint.factTypeDesc);
                    mb.invokeVirtual(CHRPriorityFactContainerCodeGenerator.this.classBuilder.getClassName(), "activate_" + constraint.name + "_" + id, TypeDesc.BOOLEAN, new TypeDesc[]{CHRContext, constraint.factTypeDesc});
                    mb.ifZeroComparisonBranch(finishLabel, "==");
                    ++id;
                }
                if (nextPriority != Integer.MAX_VALUE) {
                    mb.loadThis();
                    mb.loadField(CHRPriorityFactContainerCodeGenerator.this.containerClassName, "parent", CHRPriorityFactContainerCodeGenerator.this.storeTypeDesc);
                    mb.loadField(CHRPriorityFactContainerCodeGenerator.this.storeClassBuilder.getClassName(), CHRCodeGenerationConstants.priorityName(nextPriority), CHRPriorityFactContainer);
                    mb.loadLocal(mb.getParameter(0));
                    mb.loadLocal(mb.getParameter(1));
                    mb.invokeVirtual("org/simantics/scl/runtime/chr/CHRPriorityFactContainer", "addFact", TypeDesc.VOID, new TypeDesc[]{CHRContext, CHRFact});
                } else if (constraint.nextContainerFieldName != null && !((CHRPriorityFactContainerCodeGenerator)CHRPriorityFactContainerCodeGenerator.this).ruleset.constraintSourceMap.containsKey((Object)constraint)) {
                    mb.loadThis();
                    mb.loadField(CHRPriorityFactContainerCodeGenerator.this.containerClassName, "parent", CHRPriorityFactContainerCodeGenerator.this.storeTypeDesc);
                    mb.loadField(CHRPriorityFactContainerCodeGenerator.this.storeClassBuilder.getClassName(), constraint.nextContainerFieldName, CHRPriorityFactContainer);
                    LocalVariable containerVar = mb.createLocalVariable("container", CHRPriorityFactContainer);
                    mb.storeLocal(containerVar);
                    mb.loadLocal(containerVar);
                    mb.ifNullBranch(finishLabel, true);
                    mb.loadLocal(containerVar);
                    mb.loadLocal(mb.getParameter(0));
                    mb.loadLocal(mb.getParameter(1));
                    mb.invokeVirtual("org/simantics/scl/runtime/chr/CHRPriorityFactContainer", "addFact", TypeDesc.VOID, new TypeDesc[]{CHRContext, CHRFact});
                }
                mb.branch(finishLabel);
                return true;
            }
        });
        Label next = (Label)nextLabel.get();
        if (next != null) {
            mb.setLocation(next);
        }
        mb.setLocation(finishLabel);
        mb.returnVoid();
        mb.finish();
    }

    private void generateActivate(CHRConstraint constraint, CHRSearchPlan plan, int id) {
        MethodBuilder mb = this.classBuilder.addMethod(1, "activate_" + constraint.name + "_" + id, TypeDesc.BOOLEAN, new TypeDesc[]{CHRContext, constraint.factTypeDesc});
        LocalVariable priorityVar = new LocalVariable(0, this.containerTypeDesc);
        mb.loadLocal(priorityVar);
        mb.loadField(this.containerClassName, "parent", this.storeTypeDesc);
        LocalVariable parent = mb.createLocalVariable("parent", this.storeTypeDesc);
        mb.storeLocal(parent);
        this.ruleset.rulesetObject.realizeMethod(mb, (i, target) -> {
            mb.loadLocal(parent);
            mb.loadField(this.storeClassBuilder.getClassName(), CHRCodeGenerationConstants.parameterName(i), this.ruleset.rulesetObject.parameterTypeDescs[i]);
            mb.store(target);
        }, plan.implementation, parent, mb.getParameter(0), mb.getParameter(1));
        mb.finish();
    }
}

