/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.rules;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.THashSet;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.printing.ExpressionToStringVisitor;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.elaboration.rules.SectionName;
import org.simantics.scl.compiler.internal.parsing.Symbol;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class TransformationRule
extends Symbol {
    public static final TransformationRule[] EMPTY_ARRAY = new TransformationRule[0];
    public final boolean isAbstract;
    public final Name name;
    public final TransformationRule[] extendsRules;
    public final THashMap<SectionName, Query[]> sections;
    public final Variable[] variables;
    private Type effect;

    public TransformationRule(boolean isAbstract, Name name, TransformationRule[] extendsRules, THashMap<SectionName, Query[]> sections, Variable[] variables) {
        this.isAbstract = isAbstract;
        this.name = name;
        this.extendsRules = extendsRules;
        this.sections = sections;
        this.variables = variables;
    }

    public void checkType(final TypingContext context) {
        Variable[] variableArray = this.variables;
        int n = this.variables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable variable = variableArray[n2];
            if (variable.getType() == null) {
                variable.setType(Types.metaVar(Kinds.STAR));
            }
            ++n2;
        }
        this.sections.forEachValue((TObjectProcedure)new TObjectProcedure<Query[]>(){

            public boolean execute(Query[] queries) {
                Query[] queryArray = queries;
                int n = queries.length;
                int n2 = 0;
                while (n2 < n) {
                    Query query = queryArray[n2];
                    query.checkType(context);
                    ++n2;
                }
                return true;
            }
        });
    }

    public void setEffect(Type effect) {
        this.effect = effect;
    }

    public Type getEffect() {
        return this.effect;
    }

    public boolean forEachSection(TObjectObjectProcedure<SectionName, Query[]> procedure) {
        if (this.extendsRules.length == 0) {
            return this.sections.forEachEntry(procedure);
        }
        THashSet visitedRules = new THashSet();
        return this.forEachSection(procedure, (THashSet<TransformationRule>)visitedRules);
    }

    private boolean forEachSection(TObjectObjectProcedure<SectionName, Query[]> procedure, THashSet<TransformationRule> visitedRules) {
        if (visitedRules.add((Object)this)) {
            TransformationRule[] transformationRuleArray = this.extendsRules;
            int n = this.extendsRules.length;
            int n2 = 0;
            while (n2 < n) {
                TransformationRule rule = transformationRuleArray[n2];
                if (!rule.forEachSection(procedure, visitedRules)) {
                    return false;
                }
                ++n2;
            }
            return this.sections.forEachEntry(procedure);
        }
        return true;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        new ExpressionToStringVisitor(b).visit(this);
        return b.toString();
    }
}

