/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.query;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.scl.compiler.common.names.Names;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.QueryTransformer;
import org.simantics.scl.compiler.elaboration.query.QAbstractModifier;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.elaboration.query.QueryVisitor;
import org.simantics.scl.compiler.elaboration.query.compilation.ConstraintCollectionContext;
import org.simantics.scl.compiler.elaboration.query.compilation.DerivateException;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryCompilationContext;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryConstraint;
import org.simantics.scl.compiler.elaboration.query.compilation.UnsolvableQueryException;
import org.simantics.scl.compiler.elaboration.relations.LocalRelation;
import org.simantics.scl.compiler.types.Type;

public class QNegation
extends QAbstractModifier {
    public QNegation(Query query) {
        super(query);
    }

    @Override
    public void collectConstraints(ConstraintCollectionContext context) throws UnsolvableQueryException {
        TIntHashSet vars = new TIntHashSet();
        this.query.collectVars(context.getVariableMap(), vars);
        final QueryCompilationContext innerContext = context.getQueryCompilationContext().createCheckContext();
        this.query.generate(innerContext);
        context.addConstraint(new QueryConstraint(vars.toArray()){
            long variableMask;
            {
                super($anonymous0);
                int[] nArray = this.variables;
                int n = this.variables.length;
                int n2 = 0;
                while (n2 < n) {
                    int v = nArray[n2];
                    this.variableMask |= 1L << v;
                    ++n2;
                }
            }

            @Override
            public double getSolutionCost(long boundVariables) {
                if ((boundVariables & this.variableMask) != this.variableMask) {
                    return Double.POSITIVE_INFINITY;
                }
                return innerContext.getCost();
            }

            @Override
            public double getSolutionBranching(long boundVariables) {
                if ((boundVariables & this.variableMask) != this.variableMask) {
                    return Double.POSITIVE_INFINITY;
                }
                return innerContext.getBranching();
            }

            @Override
            public boolean canBeSolvedFrom(long boundVariables) {
                return (boundVariables & this.variableMask) == this.variableMask;
            }

            @Override
            public long getVariableMask() {
                return this.variableMask;
            }

            @Override
            public void generate(QueryCompilationContext context) {
                context.condition(new EApply(context.getConstant(Names.Prelude_not, Type.EMPTY_ARRAY), innerContext.getContinuation()));
            }
        });
    }

    @Override
    public Query replace(ReplaceContext context) {
        return new QNegation(this.query.replace(context));
    }

    @Override
    public Query.Diff[] derivate(THashMap<LocalRelation, Query.Diffable> diffables) throws DerivateException {
        Query.Diff[] diffs = this.query.derivate(diffables);
        if (diffs.length == 0) {
            return NO_DIFF;
        }
        throw new DerivateException(this.location);
    }

    @Override
    public void accept(QueryVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Query accept(QueryTransformer transformer) {
        return transformer.transform(this);
    }
}

