package org.simantics.scl.compiler.types.util;

import org.simantics.scl.compiler.types.Skeletons;
import org.simantics.scl.compiler.types.TMetaVar;
import org.simantics.scl.compiler.types.Type;

public class TypeTree<T> {
    
    public static class Case<T> {
        public Type[] types;
        public T result;
    }
    
    private static class Node<T> {
        Case<T>[] cases;
        Branch<T>[] branches;

        public Node(Case<T>[] cases) {
            this.cases = cases;
            this.branches = new Branch[cases[0].types.length];
        }
        
        Branch<T> getBranch(int i) {
            // TODO
            return null;
        }
    }
    
    private static class Branch<T> {

        public void improve(Iterator<T> iterator) {
            // TODO Auto-generated method stub
            
        }
        
    }
    
    public static class Iterator<T> {
        Node<T> node;
        Type[] scrutinee;
        
        public Iterator(Node<T> node, Type[] scrutinee) {
            this.node = node;
            this.scrutinee = scrutinee;
        }
        
        public void improve() {
            for(int i=0;i<scrutinee.length;++i) {
                Type type = scrutinee[i] = Skeletons.canonicalSkeleton(scrutinee[i]);
                if(!(type instanceof TMetaVar)) {
                   Branch<T> branch = node.getBranch(i);
                   if(branch != null) {
                       branch.improve(this);
                       --i;
                   }
                }
            }
        }
    }
    
    Node<T> root;
    
    public TypeTree(Case<T>[] cases) {
        this.root = new Node<T>(cases);
    }
    
    public Iterator<T> iterator(Type ... scrutinee) {
        return new Iterator<T>(root, scrutinee);
    }
}
