package org.simantics.scl.compiler.types.kinds;

import org.simantics.scl.compiler.types.exceptions.KindUnificationException;
import org.simantics.scl.compiler.types.util.TypeUnparsingContext;

/**
 * This class represents a kind metavariable that can contain a reference to a kind
 * that is has been unified with. 
 */
public class KMetaVar extends Kind {
    Kind ref;

    KMetaVar() {
    }

    /**
     * Write the name of the reference type, or a name returned by #tuc.
     */
    @Override
    protected void toStringPar(TypeUnparsingContext tuc, StringBuilder b) {
        if(ref != null)
            ref.toString(tuc, b);
        else
            b.append("?" + tuc.getName(this));
    }

    public void setRef(Kind a) throws KindUnificationException {
        if(a.contains(this))
            throw new KindUnificationException();
        ref = a;
    }

    @Override
    public boolean contains(KMetaVar var) {
        if(ref == null)
            return this == var;
        else
            return ref.contains(var);
    }
}
