package org.simantics.scl.compiler.top;

import org.simantics.scl.compiler.errors.CompilationError;

public class SCLExpressionCompilationException extends RuntimeException {

    private static final long serialVersionUID = 970640318254433797L;

    private final CompilationError[] errors;
    
    public SCLExpressionCompilationException(CompilationError[] errors) {
        super(createMessage(errors));
        this.errors = errors;
    }
    
    private static String createMessage(CompilationError[] errors) {
        StringBuilder b = new StringBuilder();
        for(CompilationError error : errors)
            b.append(error.description).append('\n');
        return b.toString();
    }

    public CompilationError[] getErrors() {
        return errors;
    }

}
