package org.simantics.scl.compiler.source;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

import org.simantics.scl.compiler.internal.parsing.utils.LaxUTF8Reader;
import org.simantics.scl.compiler.module.repository.UpdateListener;


public abstract class EncodedTextualModuleSource extends TextualModuleSource {

    public EncodedTextualModuleSource(String moduleName) {
        super(moduleName);
    }
    
    public EncodedTextualModuleSource(String moduleName, double priority) {
        super(moduleName, priority);
    }
    
    protected abstract InputStream getSourceStream(UpdateListener listener) throws IOException;
    
    @Override
    protected final Reader getSourceReader(UpdateListener listener)
            throws IOException {
        InputStream stream = getSourceStream(listener);
        if(stream == null)
            return null;
        else
            return new LaxUTF8Reader(new BufferedInputStream(stream));
    }
}
