package org.simantics.scl.compiler.parser.regexp;

import java.util.ArrayList;
import java.util.Arrays;

import org.simantics.scl.compiler.parser.regexp.automata.NFA;

public class RSeq extends Regexp {
    public final Regexp[] exps;

    RSeq(Regexp[] exps) {
        this.exps = exps;
    }

    @Override
    protected void buildAutomaton(NFA aut, int inState, int outState) {
        if(exps.length == 0) {
            aut.addEpsilonTransition(inState, outState);
            return;
        }
        for(int i=exps.length-1;i>0;--i) {
            int midState = aut.newState();
            exps[i].buildAutomaton(aut, midState, outState);
            outState = midState;
        }
        exps[0].buildAutomaton(aut, inState, outState);
    }
    
    @Override
    protected void toString(StringBuilder b, int prec) {
        if(prec >= 2)
            b.append('(');
        for(Regexp exp : exps)
            exp.toString(b, 2);
        if(prec >= 2)
            b.append(')');
    }
    
    @Override
    public void toString(StringBuilder b, Namer grammar, int prec) {
        if(prec >= 2)
            b.append('(');
        boolean first = true;
        for(Regexp exp : exps) {
            if(first)
                first = false;
            else
                b.append(' ');
            exp.toString(b, grammar, 2);
        }
        if(prec >= 2)
            b.append(')');
    }
    
    @Override
    protected int getTypeId() {
        return SEQ;
    }
    
    @Override
    public boolean equals(Object obj) {
        if(obj == this)
            return true;
        if(obj == null || obj.getClass() != getClass())
            return false;
        RSeq other = (RSeq)obj;
        return Arrays.equals(exps, other.exps);
    }
    
    @Override
    public int hashCode() {
        int r = 31340123;
        for(Regexp exp : exps) {
            r *= 31;
            r += exp.hashCode();
        }
        return r;
    }

    @Override
    public Regexp simplify() {
        if(exps.length == 0)
            return this;
        ArrayList<Regexp> l = new ArrayList<Regexp>(exps.length);
        for(Regexp exp : this.exps) {
            exp = exp.simplify();
            seq(l, exp);
        }
        return seq_(l);
    }
    
    @Override
    public boolean isNullable() {
        for(Regexp exp : exps)
            if(!exp.isNullable())
                return false;
        return true;
    }
}
